package systems.dennis.shared.scopes.providers;

import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.scopes.service.DictionaryService;
import systems.dennis.shared.pojo_form.DataProvider;
import systems.dennis.shared.pojo_form.ItemValue;

import java.util.ArrayList;

public class DictionaryTypeProvider implements DataProvider<String> {
    @Override
    public ArrayList<ItemValue<String>> getItems(WebContext.LocalWebContext context) {
        var types = context.getBean(DictionaryService.class).getDictionaryTypes();

        var items = new ArrayList<ItemValue<String>>();

        for (var type : types){
            items.add(new ItemValue<>(type, type));
        }


        return items;
    }
}
