package systems.dennis.shared.scopes.model;

import jakarta.persistence.Entity;
import jakarta.persistence.OneToOne;
import lombok.Data;
import systems.dennis.shared.annotations.ObjectByIdPresentation;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.scopes.service.DictionaryService;
import systems.dennis.shared.utils.bean_copier.DataTransformer;
import systems.dennis.shared.utils.bean_copier.IdToObjectTransformer;

@Data
@Entity
public class DictionaryModel extends BaseEntity {

    public static final int TYPE_INT = 0;
    public static final int TYPE_STRING = 1;
    public static final String DICTIONARY_FIELD = "value";
    @ObjectByIdPresentation
    @OneToOne @DataTransformer(transFormWith = IdToObjectTransformer.class, additionalClass = DictionaryService.class)
    private DictionaryModel parent;

    private String type;

    private Integer dataType = TYPE_STRING;

    private String value;

    @Override
    public String asValue() {

        if (parent == null){
            return  value;
        }
        return  value + " (" + parent.value + ")" ;
    }
}
