package systems.dennis.shared.scopes.form;

import lombok.Data;
import systems.dennis.shared.annotations.ObjectByIdPresentation;
import systems.dennis.shared.entity.DefaultForm;
import systems.dennis.shared.scopes.model.DictionaryModel;
import systems.dennis.shared.pojo_form.PojoFormElement;
import systems.dennis.shared.pojo_view.DEFAULT_TYPES;
import systems.dennis.shared.pojo_view.UIAction;
import systems.dennis.shared.pojo_view.list.PojoListView;
import systems.dennis.shared.pojo_view.list.PojoListViewField;
import systems.dennis.shared.pojo_view.list.Remote;
import systems.dennis.shared.scopes.service.DictionaryService;
import systems.dennis.shared.utils.bean_copier.DataTransformer;
import systems.dennis.shared.utils.bean_copier.IdToObjectTransformer;

import static systems.dennis.shared.pojo_view.DEFAULT_TYPES.NUMBER;
import static systems.dennis.shared.pojo_view.UIAction.ACTION_DELETE;
import static systems.dennis.shared.pojo_view.UIAction.ACTION_EDIT;

@Data
@PojoListView (actions = {UIAction.ACTION_NEW})
public class DictionaryForm  implements DefaultForm {
    private Long id;

    @ObjectByIdPresentation
    @DataTransformer(transFormWith = IdToObjectTransformer.class, additionalClass = DictionaryService.class)
    @PojoFormElement (type = DEFAULT_TYPES.OBJECT_SEARCH, remote = @Remote(searchField = "value", searchType = DEFAULT_TYPES.OBJECT_SEARCH, searchName = "dictionary"))
    @PojoListViewField
    private Long parent;

    @PojoFormElement
    @PojoListViewField
    private String type;

    @PojoFormElement (type = NUMBER)
    @PojoListViewField
    private Integer dataType = DictionaryModel.  TYPE_STRING;

    @PojoFormElement
    private String value;

    @PojoListViewField(actions = {@UIAction(component = ACTION_EDIT), @UIAction(ACTION_DELETE)})
    private Long actions;


}
