package systems.dennis.shared.scopes.controller;

import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.SearchEntityApi;
import systems.dennis.shared.controller.SearcherInfo;
import systems.dennis.shared.controller.items.AddItemController;
import systems.dennis.shared.controller.items.DeleteItemController;
import systems.dennis.shared.controller.items.EditItemController;
import systems.dennis.shared.controller.items.ListItemController;
import systems.dennis.shared.scopes.form.DictionaryForm;
import systems.dennis.shared.scopes.model.DictionaryModel;
import systems.dennis.shared.scopes.service.DictionaryService;
import systems.dennis.shared.utils.ApplicationContext;

@RestController
@RequestMapping("/api/v2/shared/dictionary")
@WebFormsSupport(value = DictionaryService.class)
@CrossOrigin
@Secured(roles = "ROLE_ADMIN")
public class DictionaryController
        extends ApplicationContext
        implements AddItemController<DictionaryModel, DictionaryForm>,
        EditItemController<DictionaryModel, DictionaryForm>,
        ListItemController<DictionaryModel, DictionaryForm>,
        DeleteItemController {

    static {
        SearchEntityApi.registerSearch("dictionary", new SearcherInfo(DictionaryModel.DICTIONARY_FIELD, DictionaryService.class));
    }

    public DictionaryController(WebContext context) {
        super(context);
    }
}
