/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.dbupdater.service;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.util.FileCopyUtils;
import systems.dennis.shared.dbupdater.exception.DbUpdateException;
import systems.dennis.shared.dbupdater.model.DbInjection;
import systems.dennis.shared.dbupdater.model.DbInjectionModel;
import systems.dennis.shared.dbupdater.model.DbUpdateConfig;
import systems.dennis.shared.dbupdater.repository.UpdateRepository;
import systems.dennis.shared.model.IDPresenter;
import systems.dennis.shared.postgres.bean.IsolatedDatabaseBean;
import systems.dennis.shared.utils.SimpleEvaluator;

@Service
@Scope(value="singleton")
public class Updater {
    private static final Logger log = LoggerFactory.getLogger(Updater.class);
    private static final String DEFAULT_PROFILE = "";
    private final Environment environment;
    private final EntityManagerFactory entityManagerFactory;
    private final UpdateRepository repository;
    private final DbUpdateConfig config;
    @Value(value="${spring.profiles.active:}")
    private String activeProfile;
    private final IsolatedDatabaseBean isolatedBean;
    private final SimpleEvaluator evaluator;
    private String appName;
    private boolean isFree = true;

    public Updater(DbUpdateConfig config, Environment environment, EntityManagerFactory entityManagerFactory, UpdateRepository repository, IsolatedDatabaseBean isolatedBean, SimpleEvaluator evaluator) {
        this.config = config;
        this.environment = environment;
        this.entityManagerFactory = entityManagerFactory;
        this.repository = repository;
        this.isolatedBean = isolatedBean;
        this.evaluator = evaluator;
    }

    public List<DbInjection> updateDb() throws IOException {
        this.isFree = false;
        if (!this.config.isUseDbUpdater()) {
            log.info("update db is disabled");
            return Collections.EMPTY_LIST;
        }
        this.configureAppName();
        List<DbInjection> injections = this.loadBasics(this.config.getDefaultUpdateFile());
        List<Object> custom = new ArrayList();
        try {
            custom = this.loadBasics(this.config.getProjectUpdateFile());
        }
        catch (Exception e) {
            log.info("Could not load resource from: " + this.config.getDefaultUpdateFile());
        }
        log.info("update db is enabled: " + injections.size() + " base injections found");
        for (DbInjection injection : injections) {
            if (injection.getName() == null) {
                throw new DbUpdateException("name should be set for the [base] script and should be unique" + String.valueOf((Object)injection));
            }
            for (DbInjection dbInjection : custom) {
                if (dbInjection.getName() == null) {
                    throw new DbUpdateException("name should be set for the [custom] script and should be unique" + String.valueOf((Object)injection));
                }
                if (!injection.getName().equals(dbInjection.getName())) continue;
                throw new DbUpdateException("script name overrides defaults. Change default update file with : global.basic_update_file in application properties or change name of the script " + injection.getName());
            }
        }
        log.info("Running injections of the core: " + injections.size() + " injections found");
        ArrayList<DbInjection> result = new ArrayList<DbInjection>(this.callInjections(injections));
        log.info("Finished Core, " + result.size() + " Running injections of the project: " + custom.size() + " injections found");
        int coreCount = result.size();
        result.addAll(this.callInjections(custom));
        log.info("Finished injections of the project: " + (result.size() - coreCount) + " of " + custom.size() + " injections are run");
        this.isFree = true;
        return result;
    }

    private void configureAppName() {
        InetAddress ip = InetAddress.getLocalHost();
        this.appName = "Unknown instance  : " + ip.getHostAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DbInjection> callInjections(List<DbInjection> injections) {
        ArrayList<DbInjection> result = new ArrayList<DbInjection>();
        for (DbInjection injection : injections) {
            log.debug("Processing injection " + String.valueOf((Object)injection));
            try {
                injection.setResult(true);
                if (this.checkIdentifier(injection)) {
                    if (!this.execute(injection)) continue;
                    result.add(injection);
                    continue;
                }
                log.info("Injection : " + injection.getName() + " is already run, no need to run");
            }
            catch (Throwable e) {
                injection.setMessage(e.getMessage());
                injection.setResult(false);
                log.error("Error in script: ", e);
                if (!injection.isFailOnExecute()) continue;
                throw e;
            }
            finally {
                if (injection.isIsolated()) continue;
                try {
                    this.repository.save((IDPresenter)injection);
                }
                catch (Exception e) {
                    log.info("Could not save history log for : " + String.valueOf((Object)injection));
                }
            }
        }
        return result;
    }

    private boolean checkIdentifier(DbInjection injection) {
        if (injection.isAlwaysToRun()) {
            return true;
        }
        try {
            boolean result;
            PageRequest request = PageRequest.of((int)0, (int)1, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"});
            List<DbInjection> dbInjection = this.repository.getFirstByNameAndProfile(injection.getName(), this.activeProfile, (Pageable)request);
            boolean bl = result = dbInjection.size() == 0;
            if (result) {
                return true;
            }
            log.info("Script " + injection.getName() + " was run, but failed, run it again IF it is  set so!");
            return !dbInjection.get(0).isResult() && dbInjection.get(0).isRestartOnFail();
        }
        catch (Exception e) {
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean execute(DbInjection injection) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("appName", this.appName);
        try (EntityManager session = null;){
            String ifSql;
            session = this.entityManagerFactory.createEntityManager();
            if (injection.getProfile() != null && !injection.getProfile().equalsIgnoreCase(this.activeProfile)) {
                log.info("this injection is only for profile: " + injection.getProfile() + " application is run under '" + this.activeProfile + "' profile");
                boolean bl = false;
                return bl;
            }
            if (injection.getProfile() == null) {
                injection.setProfile(DEFAULT_PROFILE);
            }
            if (injection.getIfSql() != null && this.isolatedBean.sqlWithResult(ifSql = this.evaluator.evaluate(injection.getIfSql(), 0, data), injection.root)) {
                boolean bl = false;
                return bl;
            }
            if (!injection.isIsolated()) {
                session.getTransaction().begin();
                session.createNativeQuery(this.evaluator.evaluate(injection.getSql(), 0, data)).executeUpdate();
                session.getTransaction().commit();
                session.close();
            } else if (injection.getDb() != null) {
                this.isolatedBean.sqlWithConnection(this.evaluator.evaluate(injection.getDb(), 0, data), this.evaluator.evaluate(injection.getSql(), 0, data), injection.root);
            } else {
                this.isolatedBean.sqlWithConnection(this.evaluator.evaluate(injection.getSql(), 0, data), injection.root);
            }
            boolean bl = true;
            return bl;
        }
    }

    private List<DbInjection> loadBasics(String name) {
        try {
            ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
            DbInjectionModel model = (DbInjectionModel)mapper.readValue(this.getClass().getClassLoader().getResourceAsStream(name), DbInjectionModel.class);
            List<DbInjection> scripts = model.getScripts();
            int scriptsSize = scripts.size();
            for (int i = 0; i < scriptsSize; ++i) {
                DbInjection injection = scripts.get(i);
                if (injection.getName() == null) {
                    throw new DbUpdateException("Injection should have name and it should be unique : script#" + i + " " + String.valueOf((Object)injection));
                }
                if (injection.getScript() == null && injection.getSql() == null) {
                    log.error("DB update cancelled, error");
                    throw new DbUpdateException("Injection field should neither contain script nor path to sql in the same field \"sql\"");
                }
                if (injection.getSql() != null && injection.getScript() != null) {
                    log.warn("! Both script and sql selected, only script parameter will be used! " + injection.getName());
                }
                if (injection.getScript() == null) continue;
                injection.setSql(this.readFrom(injection));
            }
            HashSet<DbInjection> injectionSet = new HashSet<DbInjection>(model.getScripts());
            if (injectionSet.size() != model.getScripts().size()) {
                throw new DbUpdateException("Looks like you have the same named object");
            }
            return model.getScripts();
        }
        catch (Exception e) {
            log.error("Could not load config file from : " + name, (Throwable)e);
            return Collections.emptyList();
        }
    }

    private String readFrom(DbInjection injection) {
        String string;
        block8: {
            InputStream inputStream = new ClassPathResource(injection.getScript()).getInputStream();
            try {
                string = FileCopyUtils.copyToString((Reader)new InputStreamReader(inputStream));
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            inputStream.close();
        }
        return string;
    }

    public List<DbInjection> getForeignListOfScripts() {
        return Collections.emptyList();
    }

    public boolean isFree() {
        return this.isFree;
    }
}

