/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.dbupdater.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Transient;
import systems.dennis.shared.entity.DefaultForm;

@Entity(name="db_injection")
public class DbInjection
implements DefaultForm {
    @Transient
    public boolean root;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="db_injection_seq")
    @SequenceGenerator(name="db_injection_seq", sequenceName="SEQ_PERSON_ID")
    private Long id;
    private String sql;
    private String name;
    @JsonProperty(value="always_to_run")
    private boolean alwaysToRun;
    @JsonProperty(value="fail_on_execute")
    private boolean failOnExecute;
    @JsonProperty(value="restart_on_fail")
    private boolean restartOnFail = false;
    private String script;
    @Column(name="if_sql")
    @JsonProperty(value="if-not-sql")
    private String ifSql;
    @Column(name="db")
    @JsonProperty(value="db")
    private String db;
    private boolean result;
    private String message;
    private String profile;
    @Transient
    private boolean isolated;

    public boolean equals(Object o) {
        if (this.getName() == null) {
            return false;
        }
        if (o instanceof String) {
            return this.getName().equals(o);
        }
        if (o instanceof DbInjection) {
            return this.getName() != null && this.getName().equals(((DbInjection)o).getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getName() == null ? 0 : this.getName().hashCode();
    }

    public boolean isRoot() {
        return this.root;
    }

    public Long getId() {
        return this.id;
    }

    public String getSql() {
        return this.sql;
    }

    public String getName() {
        return this.name;
    }

    public boolean isAlwaysToRun() {
        return this.alwaysToRun;
    }

    public boolean isFailOnExecute() {
        return this.failOnExecute;
    }

    public boolean isRestartOnFail() {
        return this.restartOnFail;
    }

    public String getScript() {
        return this.script;
    }

    public String getIfSql() {
        return this.ifSql;
    }

    public String getDb() {
        return this.db;
    }

    public boolean isResult() {
        return this.result;
    }

    public String getMessage() {
        return this.message;
    }

    public String getProfile() {
        return this.profile;
    }

    public boolean isIsolated() {
        return this.isolated;
    }

    public void setRoot(boolean root) {
        this.root = root;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="always_to_run")
    public void setAlwaysToRun(boolean alwaysToRun) {
        this.alwaysToRun = alwaysToRun;
    }

    @JsonProperty(value="fail_on_execute")
    public void setFailOnExecute(boolean failOnExecute) {
        this.failOnExecute = failOnExecute;
    }

    @JsonProperty(value="restart_on_fail")
    public void setRestartOnFail(boolean restartOnFail) {
        this.restartOnFail = restartOnFail;
    }

    public void setScript(String script) {
        this.script = script;
    }

    @JsonProperty(value="if-not-sql")
    public void setIfSql(String ifSql) {
        this.ifSql = ifSql;
    }

    @JsonProperty(value="db")
    public void setDb(String db) {
        this.db = db;
    }

    public void setResult(boolean result) {
        this.result = result;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public void setIsolated(boolean isolated) {
        this.isolated = isolated;
    }

    public String toString() {
        return "DbInjection(root=" + this.isRoot() + ", id=" + this.getId() + ", sql=" + this.getSql() + ", name=" + this.getName() + ", alwaysToRun=" + this.isAlwaysToRun() + ", failOnExecute=" + this.isFailOnExecute() + ", restartOnFail=" + this.isRestartOnFail() + ", script=" + this.getScript() + ", ifSql=" + this.getIfSql() + ", db=" + this.getDb() + ", result=" + this.isResult() + ", message=" + this.getMessage() + ", profile=" + this.getProfile() + ", isolated=" + this.isIsolated() + ")";
    }
}

