package systems.dennis.shared.postgres.service;

import systems.dennis.shared.annotations.NeverNullResponse;
import systems.dennis.shared.beans.AbstractDataFilterProvider;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.postgres.model.BaseEntity;
import systems.dennis.shared.repository.AbstractDataFilter;
import systems.dennis.shared.service.AbstractPaginationService;

import java.util.ArrayList;
import java.util.List;

public class PaginationService<DB_TYPE extends BaseEntity> extends AbstractPaginationService<DB_TYPE, Long> {
    public PaginationService(WebContext holder) {
        super(holder);
    }

    AbstractDataFilter<DB_TYPE> getFilter() {
        return getBean(AbstractDataFilterProvider.class).get();
    }

    @Override
    public Long[] updateIds(Object[] ids) {
        if (ids == null){
            return  null;
        }
        Long[] res = new Long[ids.length];
        for (int i = 0; i < ids.length; i++) {
            var id = ids[i];
            res[i] = id == null ? null : toLong(id);
        }


        return res;
    }

    @Override
    public Long updateId(Object id) {
        if (id == null){
            return  null;
        }
        return toLong(id);
    }

    private @NeverNullResponse Long toLong(Object id) {
        return  id.getClass() == Long.class ? (Long) id : Long.valueOf(id.toString());
    }
}
