/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.postgres.repository.query_processors;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import systems.dennis.shared.postgres.repository.query_processors.AbstractClassProcessor;
import systems.dennis.shared.repository.AbstractDataFilter;

public class NumberPredicateProcessor
extends AbstractClassProcessor {
    private static final Logger log = LoggerFactory.getLogger(NumberPredicateProcessor.class);

    public NumberPredicateProcessor(AbstractDataFilter queryCase, Root root) {
        super(queryCase, root);
    }

    @Override
    public Object getValue(Object value) {
        try {
            if (value instanceof Number) {
                return this.getNumberFromString(String.valueOf(value), this.getFilter().getFieldClass());
            }
            return null;
        }
        catch (Exception e) {
            log.warn("Search is not able to parse date: " + String.valueOf(value), (Throwable)e);
            return null;
        }
    }

    @Override
    public void processDefault(CriteriaBuilder criteriaBuilder, List<Predicate> predicates) {
        AbstractDataFilter filter = this.getFilter();
        Root root = this.getRoot();
        Object value = this.getValue(filter.getValue());
        if (value == null) {
            throw new ArithmeticException("Item is wrong type");
        }
        if ("lt".equalsIgnoreCase(filter.getOperator())) {
            predicates.add(criteriaBuilder.lessThan(this.getPath(root), (Comparable)((Long)value)));
        }
        if ("gt".equalsIgnoreCase(filter.getOperator())) {
            predicates.add(criteriaBuilder.greaterThan(this.getPath(root), (Comparable)((Long)value)));
        }
        if ("le".equalsIgnoreCase(filter.getOperator())) {
            predicates.add(criteriaBuilder.lessThanOrEqualTo(this.getPath(root), (Comparable)((Long)value)));
        }
        if ("ge".equalsIgnoreCase(filter.getOperator())) {
            predicates.add(criteriaBuilder.greaterThanOrEqualTo(this.getPath(root), (Comparable)((Long)value)));
        }
        if ("notNull".equalsIgnoreCase(filter.getOperator())) {
            predicates.add(criteriaBuilder.isNotNull(this.getPath(root)));
        }
        if ("null".equalsIgnoreCase(filter.getOperator())) {
            predicates.add(criteriaBuilder.isNull(this.getPath(root)));
        }
        if ("equals".equalsIgnoreCase(filter.getOperator()) && !String.class.isAssignableFrom(filter.getValue().getClass())) {
            predicates.add(criteriaBuilder.equal(this.getPath(root), value));
        }
        if ("notEquals".equalsIgnoreCase(filter.getOperator())) {
            this.addIsNullOrNotEqualPredicate(criteriaBuilder, predicates, value);
        }
        if ("in".equalsIgnoreCase(filter.getOperator())) {
            CriteriaBuilder.In inClause = criteriaBuilder.in(this.getPath(root));
            Collection cValue = (Collection)value;
            cValue.forEach(x -> inClause.value(x));
            predicates.add((Predicate)inClause);
        }
    }

    private Number getNumberFromString(String value, Class<?> fieldClass) {
        if (Integer.class.equals(fieldClass)) {
            return Integer.valueOf(value);
        }
        if (Double.class.equals(fieldClass)) {
            return Double.valueOf(value);
        }
        if (Long.class.equals(fieldClass)) {
            return Long.valueOf(value);
        }
        if (Short.class.equals(fieldClass)) {
            return Short.valueOf(value);
        }
        if (BigInteger.class.equals(fieldClass)) {
            return BigInteger.valueOf(Long.parseLong(value));
        }
        throw new IllegalArgumentException(" cannot transform String to number! ");
    }
}

