/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.postgres.repository;

import jakarta.persistence.EntityManager;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.data.repository.NoRepositoryBean;
import systems.dennis.shared.postgres.model.BaseEntity;
import systems.dennis.shared.repository.AbstractDataFilter;
import systems.dennis.shared.repository.AbstractFilterRepo;

@NoRepositoryBean
public class PaginationRepositoryImpl<ENTITY extends BaseEntity>
extends SimpleJpaRepository<ENTITY, Long>
implements AbstractFilterRepo<ENTITY, Long> {
    public PaginationRepositoryImpl(JpaEntityInformation<ENTITY, ?> entityInformation, EntityManager entityManager) {
        super(entityInformation, entityManager);
    }

    public Optional<ENTITY> filteredOne(AbstractDataFilter<?> one) {
        return super.findOne((Specification)one.getQueryRoot());
    }

    public Optional<ENTITY> filteredFirst(AbstractDataFilter<?> first) {
        Page res = super.findAll((Specification)first.getQueryRoot(), Pageable.ofSize((int)1));
        return res.isEmpty() ? Optional.empty() : Optional.of((BaseEntity)((Object)res.getContent().get(0)));
    }

    public Optional<ENTITY> filteredFirst(AbstractDataFilter<?> first, Sort sort) {
        Page res = super.findAll((Specification)first.getQueryRoot(), (Pageable)PageRequest.of((int)0, (int)1, (Sort)sort));
        return res.isEmpty() ? Optional.empty() : Optional.of((BaseEntity)((Object)res.getContent().get(0)));
    }

    public Page<ENTITY> filteredData(AbstractDataFilter<?> specification) {
        return this.findAll((Specification)specification.getQueryRoot(), Pageable.unpaged());
    }

    public Page<ENTITY> filteredData(AbstractDataFilter<?> specification, Sort sort) {
        return this.findAll((Specification)specification.getQueryRoot(), Pageable.unpaged((Sort)sort));
    }

    public Page<ENTITY> filteredData(AbstractDataFilter<?> specification, Pageable pageable) {
        return this.findAll((Specification)specification.getQueryRoot(), pageable);
    }

    public Page<ENTITY> filteredData(AbstractDataFilter<?> specification, Pageable pageable, Sort sort) {
        return this.findAll((Specification)specification.getQueryRoot(), (Pageable)PageRequest.of((int)pageable.getPageSize(), (int)pageable.getPageSize(), (Sort)sort));
    }

    public long filteredCount(AbstractDataFilter<?> filter) {
        return this.count((Specification)filter.getQueryRoot());
    }
}

