package systems.dennis.shared.postgres.service;

import org.springframework.stereotype.Service;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.postgres.form.EditHistoryForm;
import systems.dennis.shared.postgres.model.EditHistoryModel;
import systems.dennis.shared.postgres.repository.EditHistoryRepo;
import systems.dennis.shared.repository.AbstractDataFilter;

import java.io.Serializable;
import java.util.List;
import java.util.Optional;

@Service
@DataRetrieverDescription(model = EditHistoryModel.class, form = EditHistoryForm.class, repo = EditHistoryRepo.class)
public class EditHistoryService extends PaginationService<EditHistoryModel> {
    public EditHistoryService(WebContext holder) {
        super(holder);
    }

    @Override
    public Optional<EditHistoryModel> findById(Serializable id) {
        return getRepository().filteredFirst(getContext().getDataFilterProvider().id( id));
    }


    public Optional<EditHistoryModel> findByEditedTypeAndId(String type, Long id) {
       return  getRepository().filteredFirst(getFilter().eq("classEditedObject", type).and(getFilter().eq("idEditedObject", id)));

    }

    public List<EditHistoryModel> findByEditedType(String type) {
        EditHistoryRepo repo = getRepository();
        return repo.findAllByClassEditedObject(type);
    }

    @Override
    public EditHistoryRepo getRepository() {
        return super.getRepository();
    }
}
