package systems.dennis.shared.postgres.repository;

import jakarta.persistence.EntityManager;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.data.repository.NoRepositoryBean;
import systems.dennis.shared.postgres.model.BaseEntity;
import systems.dennis.shared.repository.AbstractDataFilter;
import systems.dennis.shared.repository.AbstractFilterRepo;

import java.util.Optional;


@NoRepositoryBean
public class PaginationRepositoryImpl<ENTITY extends BaseEntity> extends SimpleJpaRepository<ENTITY, Long> implements AbstractFilterRepo<ENTITY, Long> {

    public PaginationRepositoryImpl(JpaEntityInformation<ENTITY, ?> entityInformation, EntityManager entityManager) {
        super(entityInformation, entityManager);
    }

    @Override
    public Optional<ENTITY> filteredOne(AbstractDataFilter<?> one) {
        return super.findOne((Specification<ENTITY>) one.getQueryRoot());
    }



    @Override
    public Optional<ENTITY> filteredFirst(AbstractDataFilter<?> first) {
        var res =  super.findAll((Specification<ENTITY>) first.getQueryRoot(), Pageable.ofSize(1));
        return res.isEmpty() ? Optional.empty() : Optional.of(res.getContent().get(0));
    }

    @Override
    public Optional<ENTITY> filteredFirst(AbstractDataFilter<?> first, Sort sort) {
        var res =  super.findAll((Specification<ENTITY>) first.getQueryRoot(), PageRequest.of(0, 1, sort));
        return res.isEmpty() ? Optional.empty() : Optional.of(res.getContent().get(0));
    }

    @Override
    public Page<ENTITY> filteredData(AbstractDataFilter<?> specification){

        return findAll((Specification<ENTITY>)specification.getQueryRoot(), Pageable.unpaged());
    }

    @Override
    public Page<ENTITY> filteredData(AbstractDataFilter<?> specification, Sort sort) {
        return findAll((Specification<ENTITY>)specification.getQueryRoot(), Pageable.unpaged(sort));
    }

    @Override
    public Page<ENTITY> filteredData(AbstractDataFilter<?> specification, Pageable pageable) {
        return findAll((Specification<ENTITY>) specification.getQueryRoot(), pageable);
    }

    @Override
    public Page<ENTITY> filteredData(AbstractDataFilter<?> specification, Pageable pageable, Sort sort) {

        return findAll((Specification<ENTITY>) specification.getQueryRoot(), PageRequest.of(pageable.getPageSize(), pageable.getPageSize(), sort));
    }

    @Override
    public long filteredCount(AbstractDataFilter<?> filter) {
        return count((Specification<ENTITY>) filter.getQueryRoot());
    }

}
