package systems.dennis.shared.postgres.controller;

import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.controller.items.AbstractParentalController;
import systems.dennis.shared.form.CountResponse;
import systems.dennis.shared.postgres.form.DefaultForm;
import systems.dennis.shared.postgres.model.BaseEntity;

import java.util.Map;

@Secured
public interface ParentalController<T extends BaseEntity,E extends DefaultForm> extends AbstractParentalController<T,E, Long> {

    @GetMapping("/tree/count/parent/{id}")
    @ResponseBody
    @WithRole
    @Override
    default ResponseEntity<CountResponse> countByParent(@PathVariable("id") Long id) {
        return AbstractParentalController.super.countByParent(id);
    }

    @GetMapping("/tree/parent/{id}")
    @ResponseBody
    @WithRole
    @Override
    default ResponseEntity<Page<Map<String, Object>>> findByParent(@PathVariable ("id")Long id,
                                                                   @RequestParam(value = "limit", required = false) Integer limit,
                                                                   @RequestParam(value = "page", required = false) Integer page) {
        return AbstractParentalController.super.findByParent(id, limit, page);
    }

    @GetMapping("/tree/root")
    @ResponseBody
    @WithRole
    @Override
    default ResponseEntity<Page<Map<String, Object>>> findRootElements(@RequestParam(value = "limit", required = false) Integer limit,
                                                                       @RequestParam(value = "page", required = false) Integer page) {
        return AbstractParentalController.super.findRootElements(limit, page);
    }
}
