package systems.dennis.shared.postgres.controller;

import lombok.SneakyThrows;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import systems.dennis.shared.controller.items.AbstractGetByIdController;
import systems.dennis.shared.controller.items.AbstractGetOrCreateByIdController;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.postgres.form.DefaultForm;
import systems.dennis.shared.postgres.model.BaseEntity;

public interface GetOrCreateByIdController<DB_TYPE extends BaseEntity, FORM extends DefaultForm> extends AbstractGetOrCreateByIdController<DB_TYPE, FORM,  Long > {
    @SneakyThrows
    @GetMapping("/id/{id}")
    @ResponseBody
    default ResponseEntity<FORM> get(@PathVariable("id") Long id, @RequestParam(required = false) String param) {
        DB_TYPE type;

        if (id == null || id == 0) {
            type = null;
        } else {
            type = getService().findById(id).orElse(null);
        }

        if (type == null) {
            var res = getService().save(fromForm(createNew(param)));
            return ResponseEntity.ok(toForm(res));
        }
        return ResponseEntity.ok(toForm(type));
    }
}
