/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.postgres.controller;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.controller.items.AbstractListItemController;
import systems.dennis.shared.controller.items.magic.MagicRequest;
import systems.dennis.shared.postgres.form.DefaultForm;
import systems.dennis.shared.postgres.model.BaseEntity;
import systems.dennis.shared.utils.GeneratedPojoList;

@Secured
public interface ListItemController<T extends BaseEntity, E extends DefaultForm>
extends AbstractListItemController<T, E, Long> {
    @GetMapping(value={"/list"})
    @ResponseBody
    @WithRole
    default public ResponseEntity<Page<Map<String, Object>>> get(@RequestParam(value="limit", required=false) Integer limit, @RequestParam(value="page", required=false) Integer page) {
        return super.get(limit, page);
    }

    @PostMapping(value={"/root/fetch/data", "/root/fetch/data/"}, produces={"application/json"}, consumes={"application/json"})
    @ResponseBody
    @WithRole
    default public Page<Map<String, Object>> fetchData(@RequestBody MagicRequest request) {
        return super.fetchData(request);
    }

    @GetMapping(value={"/root/fetch/list", "/root/fetch/list/"}, produces={"application/json"})
    @ResponseBody
    @WithRole
    default public GeneratedPojoList fetchForm(HttpServletRequest request) {
        return super.fetchForm(request);
    }
}

