package systems.dennis.shared.postgres.controller;

import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.SearchEntityApi;
import systems.dennis.shared.controller.SearcherInfo;
import systems.dennis.shared.controller.items.AbstractListItemController;
import systems.dennis.shared.controller.items.magic.MagicRequest;
import systems.dennis.shared.postgres.form.LanguageForm;
import systems.dennis.shared.postgres.model.LanguageModel;
import systems.dennis.shared.postgres.service.LanguageService;
import systems.dennis.shared.utils.ApplicationContext;
import systems.dennis.shared.utils.GeneratedPojoList;

import java.util.Map;

@RestController
@RequestMapping("/api/v2/flaw/language")
@WebFormsSupport(LanguageService.class)
@CrossOrigin
@Secured (roles = "ROLE_ADMIN")
public class LanguageController
        extends ApplicationContext
        implements AddItemController<LanguageModel, LanguageForm>,
        EditItemController<LanguageModel, LanguageForm>,
        ListItemController<LanguageModel, LanguageForm>,
        DeleteItemController<LanguageModel> {

    static {
        SearchEntityApi.registerSearch("language", new SearcherInfo("name", LanguageService.class));
    }

    @GetMapping("/list")
    @ResponseBody
    @Override
    public ResponseEntity<Page<Map<String, Object>>> get(
            @RequestParam(value = "limit", required = false) Integer limit,
            @RequestParam(value = "page", required = false) Integer page) {
        return ListItemController.super.get( limit, page);
    }

    @PostMapping(value = {"/root/fetch/data", "/root/fetch/data/"}, produces = "application/json", consumes = "application/json")
    @ResponseBody
    @Override
    public Page<Map<String, Object>> fetchData(@RequestBody MagicRequest request) {
        return ListItemController.super.fetchData(request);
    }



    public LanguageController(WebContext context) {
        super(context);
    }

}
