package systems.dennis.shared.postgres.controller;

import lombok.SneakyThrows;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.ResponseBody;
import systems.dennis.shared.controller.items.AbstractGetByIdController;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.postgres.form.DefaultForm;
import systems.dennis.shared.postgres.model.BaseEntity;

public interface GetByIdController<DB_TYPE extends BaseEntity, FORM extends DefaultForm> extends AbstractGetByIdController<DB_TYPE, FORM,  Long > {
    @SneakyThrows
    @GetMapping("/id/{id}")
    @ResponseBody
    default ResponseEntity<FORM> get(@PathVariable("id") Long id) {
        DB_TYPE type = (DB_TYPE) getService().findById(id).orElseThrow(() -> ItemNotFoundException.fromId(id));
        if (type == null){
            throw ItemNotFoundException.fromId(id);
        }
        return ResponseEntity.ok(toForm(type));
    }
}
