/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.postgres.service;

import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.postgres.form.EditHistoryForm;
import systems.dennis.shared.postgres.model.EditHistoryModel;
import systems.dennis.shared.postgres.repository.EditHistoryRepo;
import systems.dennis.shared.postgres.service.PaginationService;

@Service
@DataRetrieverDescription(model=EditHistoryModel.class, form=EditHistoryForm.class, repo=EditHistoryRepo.class)
public class EditHistoryService
extends PaginationService<EditHistoryModel> {
    public EditHistoryService(WebContext holder) {
        super(holder);
    }

    public Optional<EditHistoryModel> findById(Serializable id) {
        return this.getRepository().filteredFirst(this.getContext().getDataFilterProvider().id((Object)id));
    }

    public Optional<EditHistoryModel> findByEditedTypeAndId(String type, Long id) {
        return this.getRepository().filteredFirst(this.getFilter().eq("classEditedObject", (Object)type).and(this.getFilter().eq("idEditedObject", (Object)id)));
    }

    public List<EditHistoryModel> findByEditedType(String type) {
        EditHistoryRepo repo = this.getRepository();
        return repo.findAllByClassEditedObject(type);
    }

    public EditHistoryRepo getRepository() {
        return (EditHistoryRepo)super.getRepository();
    }
}

