/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.postgres.repository.query_processors;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.List;
import systems.dennis.shared.postgres.repository.SpecificationFilter;
import systems.dennis.shared.postgres.repository.query_processors.AbstractClassProcessor;
import systems.dennis.shared.repository.AbstractDataFilter;

public class StringPredicateProcessor
extends AbstractClassProcessor {
    public StringPredicateProcessor(SpecificationFilter queryCase, Root root) {
        super(queryCase, root);
    }

    @Override
    public void processDefault(CriteriaBuilder criteriaBuilder, List<Predicate> predicates) {
        boolean selectInsensitive = true;
        AbstractDataFilter queryCase = this.getFilter();
        try {
            selectInsensitive = (Boolean)this.getParameter();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String valueEx = String.valueOf(queryCase.getValue());
        if ("contains".equalsIgnoreCase(queryCase.getOperator())) {
            if (!selectInsensitive) {
                predicates.add(criteriaBuilder.like(this.getPath(this.getRoot()), "%" + String.valueOf(queryCase.getValue()) + "%"));
            } else {
                predicates.add(criteriaBuilder.like(criteriaBuilder.lower(this.getPath(this.getRoot())), "%" + queryCase.getValue().toString().toLowerCase() + "%"));
            }
        }
        if ("_nc_".equalsIgnoreCase(queryCase.getOperator())) {
            if (!selectInsensitive) {
                predicates.add(criteriaBuilder.notLike(criteriaBuilder.lower(this.getPath(this.getRoot())), "%" + queryCase.getValue().toString().toLowerCase() + "%"));
            } else {
                predicates.add(criteriaBuilder.notLike(this.getPath(this.getRoot()), "%" + String.valueOf(queryCase.getValue()) + "%"));
            }
        }
        if ("equals".equalsIgnoreCase(queryCase.getOperator())) {
            if (selectInsensitive) {
                predicates.add(criteriaBuilder.equal(criteriaBuilder.lower(this.getPath(this.getRoot())), (Object)valueEx.toLowerCase()));
            } else {
                predicates.add(criteriaBuilder.equal(this.getPath(this.getRoot()), queryCase.getValue()));
            }
        }
        if ("notEquals".equalsIgnoreCase(queryCase.getOperator())) {
            this.addIsNullOrNotEqualPredicate(criteriaBuilder, predicates, queryCase.getValue());
        }
        if ("startsWith".equalsIgnoreCase(queryCase.getOperator())) {
            if (selectInsensitive) {
                predicates.add(criteriaBuilder.like(criteriaBuilder.lower(this.getPath(this.getRoot())), queryCase.getValue().toString().toLowerCase() + "%"));
            } else {
                predicates.add(criteriaBuilder.like(this.getPath(this.getRoot()), String.valueOf(queryCase.getValue()) + "%"));
            }
        }
        if ("notStartsWith".equalsIgnoreCase(queryCase.getOperator())) {
            if (selectInsensitive) {
                predicates.add(criteriaBuilder.notLike(criteriaBuilder.lower(this.getPath(this.getRoot())), queryCase.getValue().toString().toLowerCase() + "%"));
            } else {
                predicates.add(criteriaBuilder.notLike(this.getPath(this.getRoot()), String.valueOf(queryCase.getValue()) + "%"));
            }
        }
        if ("endsWith".equalsIgnoreCase(queryCase.getOperator())) {
            if (selectInsensitive) {
                predicates.add(criteriaBuilder.like(this.getPath(this.getRoot()), "%" + String.valueOf(queryCase.getValue())));
            } else {
                predicates.add(criteriaBuilder.like(criteriaBuilder.lower(this.getPath(this.getRoot())), "%" + queryCase.getValue().toString().toLowerCase()));
            }
        }
        if ("notEndsWith".equalsIgnoreCase(queryCase.getOperator())) {
            if (selectInsensitive) {
                predicates.add(criteriaBuilder.notLike(this.getPath(this.getRoot()), "%" + String.valueOf(queryCase.getValue())));
            } else {
                predicates.add(criteriaBuilder.notLike(criteriaBuilder.lower(this.getPath(this.getRoot())), "%" + queryCase.getValue().toString().toLowerCase()));
            }
        }
    }

    @Override
    public Object getValue(Object value) {
        return value;
    }
}

