/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.postgres.controller;

import java.io.Serializable;
import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.shared.annotations.security.Id;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.controller.items.AbstractDeleteItemController;
import systems.dennis.shared.exceptions.ItemForAddContainsIdException;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.exceptions.ItemNotUserException;
import systems.dennis.shared.postgres.model.BaseEntity;
import systems.dennis.shared.utils.security.DefaultIdChecker;

@RestController
@Secured
public interface DeleteItemController<T extends BaseEntity>
extends AbstractDeleteItemController<T, Long> {
    @DeleteMapping(value={"/delete/{id}"}, consumes={"application/json", "application/json;charset=UTF-8"}, produces={"application/json", "application/json;charset=UTF-8"})
    @ResponseBody
    @WithRole
    default public void delete(@Id(checker=DefaultIdChecker.class) @PathVariable Long id) throws ItemForAddContainsIdException {
        super.delete((Serializable)id);
    }

    @WithRole
    @RequestMapping(value={"/delete/deleteItems"}, method={RequestMethod.POST})
    default public void deleteItems(@RequestParam List<Long> ids) throws ItemNotUserException, ItemNotFoundException {
        super.deleteItems(ids);
    }
}

