/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.postgres.service;

import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.postgres.form.DeleteHistoryForm;
import systems.dennis.shared.postgres.model.DeleteHistoryModel;
import systems.dennis.shared.postgres.repository.DeleteHistoryRepo;
import systems.dennis.shared.postgres.service.PaginationService;

@Service
@DataRetrieverDescription(model=DeleteHistoryModel.class, form=DeleteHistoryForm.class, repo=DeleteHistoryRepo.class)
public class DeleteHistoryService
extends PaginationService<DeleteHistoryModel> {
    public DeleteHistoryService(WebContext holder) {
        super(holder);
    }

    public Optional<DeleteHistoryModel> findById(Long id) {
        return this.getRepository().findById((Object)id);
    }

    public boolean existsByTypeAndDeletedId(Long id, String type) {
        DeleteHistoryRepo repo = (DeleteHistoryRepo)this.getRepository();
        return repo.existsByIdDeletedObjectAndClassDeletedObject(id, type);
    }

    public Optional<DeleteHistoryModel> findByTypeAndDeletedId(String type, Long id) {
        DeleteHistoryRepo repo = (DeleteHistoryRepo)this.getRepository();
        return repo.findFirstByIdDeletedObjectAndClassDeletedObject(id, type);
    }

    public List<DeleteHistoryModel> findByType(String type) {
        DeleteHistoryRepo repo = (DeleteHistoryRepo)this.getRepository();
        return repo.findAllByClassDeletedObject(type);
    }
}

