/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.postgres.repository;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.io.Serializable;
import java.util.ArrayList;
import org.springframework.data.jpa.domain.Specification;
import systems.dennis.shared.exceptions.StandardException;
import systems.dennis.shared.model.IDPresenter;
import systems.dennis.shared.postgres.repository.query_processors.AbstractClassProcessor;
import systems.dennis.shared.repository.AbstractDataFilter;

public class SpecificationFilter<T extends IDPresenter<?>>
implements AbstractDataFilter<T> {
    boolean empty = true;
    private Specification<T> root;
    private boolean complex;
    private String on;
    private Class<?> type;
    private boolean insensitive;
    private boolean closed;
    private String operationType;
    private Object value;
    private String field;

    public SpecificationFilter<T> operator(String field, Object value, String type) {
        if (this.isClosed()) {
            throw new StandardException((Serializable)((Object)"query_was_already_closed"), "only add/or functions are now available. Please check that 'operation' is performed after additional parameter' ");
        }
        if (field != null && type != null) {
            this.setEmpty(false);
        }
        this.field = field;
        this.value = value;
        this.operationType = type;
        this.root = new Specification<T>(){

            public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
                AbstractClassProcessor qq = AbstractClassProcessor.processor(SpecificationFilter.this, root);
                ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                if (!qq.isNotNullCase()) {
                    qq.addToNullOrNotNullPredicate(criteriaBuilder, root, predicates);
                } else {
                    qq.processDefault(criteriaBuilder, predicates);
                }
                return criteriaBuilder.and(predicates.toArray(new Predicate[predicates.size()]));
            }
        };
        this.closed = true;
        return this;
    }

    private Specification<T> getRoot() {
        return this.root;
    }

    public <E extends AbstractDataFilter<?>> E and(E filter) {
        if (this.root == null) {
            throw new StandardException((Serializable)((Object)"query_has_still_open"), "close query to use 'and' operator");
        }
        if (this.isEmpty(filter)) {
            return (E)this;
        }
        SpecificationFilter item = (SpecificationFilter)filter;
        this.empty = false;
        this.root = this.root.and(item.getRoot());
        return (E)this;
    }

    public <E extends AbstractDataFilter<?>> E or(E filter) {
        if (this.root == null) {
            throw new StandardException((Serializable)((Object)"query_has_still_open"), "close query to use 'or' operator");
        }
        if (filter.isEmpty()) {
            return (E)this;
        }
        SpecificationFilter item = (SpecificationFilter)filter;
        this.root = this.root.and(item.getRoot());
        this.empty = false;
        return (E)this;
    }

    public <E extends AbstractDataFilter<T>> E comparasionType(Class<?> type) {
        this.type = type;
        return (E)this;
    }

    public SpecificationFilter<T> setInsensitive(boolean insensitive) {
        this.insensitive = insensitive;
        return this;
    }

    public SpecificationFilter<T> setComplex(boolean complex) {
        this.complex = complex;
        return this;
    }

    public SpecificationFilter<T> setJoinOn(String on) {
        this.on = on;
        return this;
    }

    public Serializable getIdValue(Object id) {
        return (Long)id;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public String getOperator() {
        return this.operationType;
    }

    boolean isEmpty(AbstractDataFilter<?> filter) {
        return filter == null || filter.isEmpty();
    }

    public Class<?> getFieldClass() {
        try {
            return this.type == null ? this.getValue().getClass() : this.type;
        }
        catch (Exception e) {
            return String.class;
        }
    }

    public <T1> T1 getQueryRoot() {
        return (T1)this.root;
    }

    public boolean getInsensitive() {
        return this.insensitive;
    }

    public boolean isComplex() {
        return this.complex;
    }

    public String getOn() {
        return this.on;
    }

    public Class<?> getType() {
        return this.type;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public String getOperationType() {
        return this.operationType;
    }

    public Object getValue() {
        return this.value;
    }

    public String getField() {
        return this.field;
    }

    public void setEmpty(boolean empty) {
        this.empty = empty;
    }

    public void setRoot(Specification<T> root) {
        this.root = root;
    }

    public void setOn(String on) {
        this.on = on;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public void setOperationType(String operationType) {
        this.operationType = operationType;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setField(String field) {
        this.field = field;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpecificationFilter)) {
            return false;
        }
        SpecificationFilter other = (SpecificationFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEmpty() != other.isEmpty()) {
            return false;
        }
        if (this.isComplex() != other.isComplex()) {
            return false;
        }
        if (this.getInsensitive() != other.getInsensitive()) {
            return false;
        }
        if (this.isClosed() != other.isClosed()) {
            return false;
        }
        Specification<T> this$root = this.getRoot();
        Specification<T> other$root = other.getRoot();
        if (this$root == null ? other$root != null : !this$root.equals(other$root)) {
            return false;
        }
        String this$on = this.getOn();
        String other$on = other.getOn();
        if (this$on == null ? other$on != null : !this$on.equals(other$on)) {
            return false;
        }
        Class<?> this$type = this.getType();
        Class<?> other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$operationType = this.getOperationType();
        String other$operationType = other.getOperationType();
        if (this$operationType == null ? other$operationType != null : !this$operationType.equals(other$operationType)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$field = this.getField();
        String other$field = other.getField();
        return !(this$field == null ? other$field != null : !this$field.equals(other$field));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SpecificationFilter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEmpty() ? 79 : 97);
        result = result * 59 + (this.isComplex() ? 79 : 97);
        result = result * 59 + (this.getInsensitive() ? 79 : 97);
        result = result * 59 + (this.isClosed() ? 79 : 97);
        Specification<T> $root = this.getRoot();
        result = result * 59 + ($root == null ? 43 : $root.hashCode());
        String $on = this.getOn();
        result = result * 59 + ($on == null ? 43 : $on.hashCode());
        Class<?> $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $operationType = this.getOperationType();
        result = result * 59 + ($operationType == null ? 43 : $operationType.hashCode());
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $field = this.getField();
        result = result * 59 + ($field == null ? 43 : $field.hashCode());
        return result;
    }

    public String toString() {
        return "SpecificationFilter(empty=" + this.isEmpty() + ", root=" + String.valueOf(this.getRoot()) + ", complex=" + this.isComplex() + ", on=" + this.getOn() + ", type=" + String.valueOf(this.getType()) + ", insensitive=" + this.getInsensitive() + ", closed=" + this.isClosed() + ", operationType=" + this.getOperationType() + ", value=" + String.valueOf(this.getValue()) + ", field=" + this.getField() + ")";
    }
}

