package systems.dennis.shared.postgres.controller;

import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.controller.items.AbstractSelfItemsListController;
import systems.dennis.shared.postgres.model.BaseEntity;
import systems.dennis.shared.postgres.form.DefaultForm;

@RestController
@Secured
public interface SelfItemsListController<T extends BaseEntity,E extends DefaultForm> extends AbstractSelfItemsListController<T,E, Long> {

    @GetMapping("/list")
    @ResponseBody
    @WithRole
    @Override
    default ResponseEntity<Page<E>> getData(
                                            @RequestParam (value = "limit", required = false) Integer limit,
                                            @RequestParam(value = "page", required = false) Integer page) {
        return AbstractSelfItemsListController.super.getData(limit, page);
    }
}
