package systems.dennis.shared.postgres.controller;

import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.controller.items.AbstractListItemController;
import systems.dennis.shared.controller.items.magic.MagicRequest;
import systems.dennis.shared.postgres.model.BaseEntity;
import systems.dennis.shared.postgres.form.DefaultForm;
import systems.dennis.shared.utils.GeneratedPojoList;

import java.util.Map;

@RestController
@Secured
public interface ListItemController<T extends BaseEntity,E extends DefaultForm> extends AbstractListItemController<T,E, Long> {

    @GetMapping("/list")
    @ResponseBody
    @WithRole
    @Override
    default ResponseEntity<Page<Map<String, Object>>> get(
                                                          @RequestParam(value = "limit", required = false) Integer limit,
                                                          @RequestParam(value = "page", required = false) Integer page) {
        return AbstractListItemController.super.get( limit, page);
    }

    @PostMapping(value = {"/root/fetch/data", "/root/fetch/data/"}, produces = "application/json", consumes = "application/json")
    @ResponseBody
    @WithRole
    @Override
    default Page<Map<String, Object>> fetchData(@RequestBody MagicRequest request) {
        return AbstractListItemController.super.fetchData(request);
    }


    @GetMapping(value = {"/root/fetch/list", "/root/fetch/list/"}, produces = "application/json")
    @ResponseBody
    @WithRole
    @Override
    default GeneratedPojoList fetchForm() {
        return AbstractListItemController.super.fetchForm();
    }
}
