package systems.dennis.shared.postgres.controller;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.controller.items.AbstractEditItemController;
import systems.dennis.shared.exceptions.ItemForAddContainsIdException;
import systems.dennis.shared.postgres.model.BaseEntity;
import systems.dennis.shared.postgres.form.DefaultForm;

@RestController
@Secured
public interface EditItemController<T extends BaseEntity, E extends DefaultForm> extends AbstractEditItemController<T,E, Long> {


    @PostMapping(value = "/edit",  consumes = {"application/json", "application/json;charset=UTF-8"}, produces = {"application/json", "application/json;charset=UTF-8"})
    @ResponseBody
    @WithRole
    @Override
    default ResponseEntity<E> edit(@RequestBody E form) throws ItemForAddContainsIdException {
        return AbstractEditItemController.super.edit(form);
    }

}
