/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.postgres.service;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.transaction.Transactional;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.annotations.security.ISecurityUtils;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.forms.QueryObject;
import systems.dennis.shared.entity.AbstractEntity;
import systems.dennis.shared.entity.KeyValue;
import systems.dennis.shared.exceptions.ItemDoesNotContainsIdValueException;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.exceptions.ItemNotUserException;
import systems.dennis.shared.exceptions.UnmodifiedItemSaveAttemptException;
import systems.dennis.shared.postgres.model.BaseEntity;
import systems.dennis.shared.repository.AbstractRepository;
import systems.dennis.shared.repository.QueryCase;
import systems.dennis.shared.service.AbstractService;
import systems.dennis.shared.utils.ApplicationContext;
import systems.dennis.shared.utils.bean_copier.BeanCopier;

public abstract class PaginationService<DB_TYPE extends BaseEntity>
extends ApplicationContext
implements AbstractService<DB_TYPE, Long> {
    private static final Logger log = LoggerFactory.getLogger(PaginationService.class);
    @PersistenceContext
    private EntityManager entityManager;

    public PaginationService(WebContext holder) {
        super(holder);
    }

    public Logger getLogger() {
        return log;
    }

    public boolean exists(DB_TYPE object) {
        return this.getRepository().existsById((Object)((BaseEntity)object).getId());
    }

    public DB_TYPE save(DB_TYPE model) {
        if (((BaseEntity)model).getId() != null && !((BaseEntity)model).isIdSet()) {
            ((BaseEntity)model).setId(null);
        }
        if (((BaseEntity)model).getId() != null) {
            Session session = (Session)this.entityManager.unwrap(Session.class);
            session.evict(model);
            return (DB_TYPE)this.edit((DB_TYPE)((BaseEntity)((BeanCopier)this.getBean(BeanCopier.class)).clone(model)));
        }
        this.preAdd((AbstractEntity)model);
        this.assignUser((AbstractEntity)model);
        BaseEntity res = (BaseEntity)this.getRepository().save(model);
        this.afterAdd(res);
        return (DB_TYPE)res;
    }

    public void preFetchOriginal(DB_TYPE form) {
    }

    public List<QueryCase> getAdditionalCases(QueryObject<String> parameters) {
        return Collections.emptyList();
    }

    public List<DB_TYPE> find() {
        return this.find(false);
    }

    public List<DB_TYPE> find(Boolean ignoreAdditionalSpecification) {
        ArrayList result = new ArrayList();
        if (ignoreAdditionalSpecification.booleanValue()) {
            this.getRepository().findAll().forEach(result::add);
        } else {
            this.getRepository().findAll(this.getAdditionalSpecification()).forEach(result::add);
        }
        return result;
    }

    public DB_TYPE edit(DB_TYPE model) throws ItemNotUserException, ItemNotFoundException, UnmodifiedItemSaveAttemptException, ItemDoesNotContainsIdValueException {
        Long editedId = ((BaseEntity)model).getId();
        BaseEntity cloneOfOriginal = (BaseEntity)this.findByIdClone(editedId).orElseThrow(() -> new ItemNotFoundException((Serializable)editedId));
        if (Objects.equals(model, cloneOfOriginal)) {
            throw new UnmodifiedItemSaveAttemptException("Object not changed");
        }
        BeanCopier copier = (BeanCopier)this.getContext().getBean(BeanCopier.class);
        copier.copyTransientFields(model, (AbstractEntity)cloneOfOriginal);
        this.assignUser((AbstractEntity)model, cloneOfOriginal);
        model = (BaseEntity)this.preEdit((AbstractEntity)model, cloneOfOriginal);
        BaseEntity res = (BaseEntity)this.getRepository().save(model);
        this.saveVersionIfRequired(cloneOfOriginal, (AbstractEntity)model);
        this.afterEdit(res, cloneOfOriginal);
        return (DB_TYPE)res;
    }

    public void afterEdit(DB_TYPE object, DB_TYPE original) {
    }

    public KeyValue editField(Long id, KeyValue keyValue) throws ItemNotUserException, ItemNotFoundException, UnmodifiedItemSaveAttemptException, ItemDoesNotContainsIdValueException, IllegalAccessException, InvocationTargetException {
        BaseEntity original = (BaseEntity)this.getRepository().findById((Object)id).orElseThrow(() -> new ItemNotFoundException((Serializable)id));
        BaseEntity cloneOfOriginal = (BaseEntity)((BeanCopier)this.getContext().getBean(BeanCopier.class)).clone((Object)original);
        Field field = BeanCopier.findField((String)keyValue.getKey(), cloneOfOriginal.getClass());
        BeanCopier.setFieldValue((Object)cloneOfOriginal, (Field)field, (Object)keyValue.getValue());
        cloneOfOriginal = this.edit((DB_TYPE)cloneOfOriginal);
        Object valueFromModel = BeanCopier.readValue((Object)cloneOfOriginal, (String)keyValue.getKey());
        return new KeyValue(keyValue.getKey(), valueFromModel);
    }

    @Transactional
    public void deleteItems(List<Long> ids) throws ItemNotUserException, ItemNotFoundException {
        ids.forEach(arg_0 -> ((PaginationService)this).delete(arg_0));
    }

    public <F extends AbstractRepository<DB_TYPE, Long>> F getRepository() {
        return (F)((AbstractRepository)this.getContext().getBean(((Object)((Object)this)).getClass().getAnnotation(DataRetrieverDescription.class).repo()));
    }

    public <T extends ISecurityUtils> T getUtils() {
        return (T)((ISecurityUtils)this.getContext().getBean(ISecurityUtils.class));
    }

    public boolean isIdSet(Long id) {
        return id != null && id > 0L;
    }
}

