/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.postgres.service;

import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.postgres.form.EditHistoryForm;
import systems.dennis.shared.postgres.model.EditHistoryModel;
import systems.dennis.shared.postgres.repository.EditHistoryRepo;
import systems.dennis.shared.postgres.service.PaginationService;
import systems.dennis.shared.repository.QueryCase;

@Service
@DataRetrieverDescription(model=EditHistoryModel.class, form=EditHistoryForm.class, repo=EditHistoryRepo.class)
public class EditHistoryService
extends PaginationService<EditHistoryModel> {
    public EditHistoryService(WebContext holder) {
        super(holder);
    }

    public Optional<EditHistoryModel> findById(Long id) {
        return this.getRepository().findOne((Specification)QueryCase.equalsOf((String)"id", (Object)id).integer().specification());
    }

    public Optional<EditHistoryModel> findByEditedTypeAndId(String type, Long id) {
        EditHistoryRepo repo = (EditHistoryRepo)this.getRepository();
        return repo.findFirstByClassEditedObjectAndIdEditedObject(type, id);
    }

    public List<EditHistoryModel> findByEditedType(String type) {
        EditHistoryRepo repo = (EditHistoryRepo)this.getRepository();
        return repo.findAllByClassEditedObject(type);
    }
}

