/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.postgres.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import java.util.Date;
import systems.dennis.shared.postgres.model.BaseEntity;

@Entity(name="edit_history_object")
public class EditHistoryModel
extends BaseEntity {
    @Column(name="edited_id")
    private Long idEditedObject;
    private Date editedDate = new Date();
    @Column(name="object_type")
    private String classEditedObject;
    @Column(columnDefinition="text")
    private String oldContent;
    @Column(columnDefinition="text")
    private String newContent;

    public static EditHistoryModel from(BaseEntity original, BaseEntity edited) {
        ObjectMapper objectMapper = new ObjectMapper();
        String oldContent = objectMapper.writeValueAsString((Object)original);
        String newContent = objectMapper.writeValueAsString((Object)edited);
        EditHistoryModel model = new EditHistoryModel();
        model.setIdEditedObject(original.getId());
        model.setClassEditedObject(original.getClass().getSimpleName());
        model.setOldContent(oldContent);
        model.setNewContent(newContent);
        return model;
    }

    public Long getIdEditedObject() {
        return this.idEditedObject;
    }

    public Date getEditedDate() {
        return this.editedDate;
    }

    public String getClassEditedObject() {
        return this.classEditedObject;
    }

    public String getOldContent() {
        return this.oldContent;
    }

    public String getNewContent() {
        return this.newContent;
    }

    public void setIdEditedObject(Long idEditedObject) {
        this.idEditedObject = idEditedObject;
    }

    public void setEditedDate(Date editedDate) {
        this.editedDate = editedDate;
    }

    public void setClassEditedObject(String classEditedObject) {
        this.classEditedObject = classEditedObject;
    }

    public void setOldContent(String oldContent) {
        this.oldContent = oldContent;
    }

    public void setNewContent(String newContent) {
        this.newContent = newContent;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EditHistoryModel)) {
            return false;
        }
        EditHistoryModel other = (EditHistoryModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$idEditedObject = this.getIdEditedObject();
        Long other$idEditedObject = other.getIdEditedObject();
        if (this$idEditedObject == null ? other$idEditedObject != null : !((Object)this$idEditedObject).equals(other$idEditedObject)) {
            return false;
        }
        Date this$editedDate = this.getEditedDate();
        Date other$editedDate = other.getEditedDate();
        if (this$editedDate == null ? other$editedDate != null : !((Object)this$editedDate).equals(other$editedDate)) {
            return false;
        }
        String this$classEditedObject = this.getClassEditedObject();
        String other$classEditedObject = other.getClassEditedObject();
        if (this$classEditedObject == null ? other$classEditedObject != null : !this$classEditedObject.equals(other$classEditedObject)) {
            return false;
        }
        String this$oldContent = this.getOldContent();
        String other$oldContent = other.getOldContent();
        if (this$oldContent == null ? other$oldContent != null : !this$oldContent.equals(other$oldContent)) {
            return false;
        }
        String this$newContent = this.getNewContent();
        String other$newContent = other.getNewContent();
        return !(this$newContent == null ? other$newContent != null : !this$newContent.equals(other$newContent));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof EditHistoryModel;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $idEditedObject = this.getIdEditedObject();
        result = result * 59 + ($idEditedObject == null ? 43 : ((Object)$idEditedObject).hashCode());
        Date $editedDate = this.getEditedDate();
        result = result * 59 + ($editedDate == null ? 43 : ((Object)$editedDate).hashCode());
        String $classEditedObject = this.getClassEditedObject();
        result = result * 59 + ($classEditedObject == null ? 43 : $classEditedObject.hashCode());
        String $oldContent = this.getOldContent();
        result = result * 59 + ($oldContent == null ? 43 : $oldContent.hashCode());
        String $newContent = this.getNewContent();
        result = result * 59 + ($newContent == null ? 43 : $newContent.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "EditHistoryModel(idEditedObject=" + this.getIdEditedObject() + ", editedDate=" + String.valueOf(this.getEditedDate()) + ", classEditedObject=" + this.getClassEditedObject() + ", oldContent=" + this.getOldContent() + ", newContent=" + this.getNewContent() + ")";
    }
}

