/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.postgres.model;

import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.MappedSuperclass;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import systems.dennis.shared.annotations.FormTransient;
import systems.dennis.shared.entity.AbstractEntity;

@MappedSuperclass
public class BaseEntity
implements AbstractEntity<Long> {
    public static final int DELETE_STRATEGY_DB = 1;
    public static final int DELETE_STRATEGY_PROPERTY = 2;
    public static final String DELETE_PROPERTY = "hidden";
    @Id
    @GeneratedValue(generator="entity-aware-generator", strategy=GenerationType.SEQUENCE)
    @GenericGenerator(name="entity-aware-generator", parameters={@Parameter(name="increment_size", value="1"), @Parameter(name="initial_value", value="100")}, strategy="systems.dennis.shared.postgres.model.ByEntityNameSequenceGenerator")
    private Long id;
    @FormTransient
    Boolean hidden;

    public String asValue() {
        return String.valueOf(this.id);
    }

    public boolean isIdSet() {
        return this.id != null && this.id > 0L;
    }

    public Long getId() {
        return this.id;
    }

    public Boolean getHidden() {
        return this.hidden;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseEntity)) {
            return false;
        }
        BaseEntity other = (BaseEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Boolean this$hidden = this.getHidden();
        Boolean other$hidden = other.getHidden();
        return !(this$hidden == null ? other$hidden != null : !((Object)this$hidden).equals(other$hidden));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Boolean $hidden = this.getHidden();
        result = result * 59 + ($hidden == null ? 43 : ((Object)$hidden).hashCode());
        return result;
    }

    public String toString() {
        return "BaseEntity(id=" + this.getId() + ", hidden=" + this.getHidden() + ")";
    }
}

