/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.postgres.controller;

import java.util.List;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.annotations.security.SelfOnlyRole;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.exceptions.EditableObjectNotFoundException;
import systems.dennis.shared.postgres.controller.ListItemController;
import systems.dennis.shared.postgres.form.EditHistoryForm;
import systems.dennis.shared.postgres.model.EditHistoryModel;
import systems.dennis.shared.postgres.service.EditHistoryService;
import systems.dennis.shared.utils.ApplicationContext;

@RestController
@RequestMapping(value={"/api/v2/edited/history"})
@WebFormsSupport(value=EditHistoryService.class)
public class EditHistoryController
extends ApplicationContext
implements ListItemController<EditHistoryModel, EditHistoryForm> {
    public EditHistoryController(WebContext context) {
        super(context);
    }

    @SelfOnlyRole
    @GetMapping(value={"/find/{type}/{id}"})
    public EditHistoryForm findByEditedTypeAndId(@PathVariable String type, @PathVariable Long id) {
        EditHistoryService service = (EditHistoryService)this.getService();
        return (EditHistoryForm)this.toForm(service.findByEditedTypeAndId(type, id).orElseThrow(() -> new EditableObjectNotFoundException(type, id)));
    }

    @SelfOnlyRole
    @GetMapping(value={"/find/{type}"})
    public List<EditHistoryForm> findAllByType(@PathVariable String type) {
        EditHistoryService service = (EditHistoryService)this.getService();
        return service.findByEditedType(type).stream().map(arg_0 -> ((EditHistoryController)this).toForm(arg_0)).collect(Collectors.toList());
    }
}

