/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.postgres.controller;

import java.util.List;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.annotations.security.SelfOnlyRole;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.exceptions.HistoryObjectNotFoundException;
import systems.dennis.shared.postgres.controller.ListItemController;
import systems.dennis.shared.postgres.form.DeleteHistoryForm;
import systems.dennis.shared.postgres.model.DeleteHistoryModel;
import systems.dennis.shared.postgres.service.DeleteHistoryService;
import systems.dennis.shared.utils.ApplicationContext;

@RestController
@RequestMapping(value={"/api/v2/deleted/history"})
@WebFormsSupport(value=DeleteHistoryService.class)
public class DeleteHistoryController
extends ApplicationContext
implements ListItemController<DeleteHistoryModel, DeleteHistoryForm> {
    public DeleteHistoryController(WebContext context) {
        super(context);
    }

    @GetMapping(value={"/find/{type}/{id}"})
    @SelfOnlyRole
    public DeleteHistoryForm findByDeletedIdAndType(@PathVariable String type, @PathVariable Long id) {
        DeleteHistoryService service = (DeleteHistoryService)this.getService();
        return (DeleteHistoryForm)this.toForm(service.findByTypeAndDeletedId(type, id).orElseThrow(() -> new HistoryObjectNotFoundException(id, type)));
    }

    @GetMapping(value={"/find/{type}"})
    @SelfOnlyRole
    public List<DeleteHistoryForm> findByType(@PathVariable String type) {
        DeleteHistoryService service = (DeleteHistoryService)this.getService();
        return service.findByType(type).stream().map(arg_0 -> ((DeleteHistoryController)this).toForm(arg_0)).collect(Collectors.toList());
    }
}

