/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.postgres.controller;

import java.util.Map;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.exceptions.ItemDoesNotContainsIdValueException;
import systems.dennis.shared.exceptions.ItemForAddContainsIdException;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.exceptions.ItemNotUserException;
import systems.dennis.shared.exceptions.UnmodifiedItemSaveAttemptException;
import systems.dennis.shared.postgres.controller.AddItemController;
import systems.dennis.shared.postgres.controller.DeleteItemController;
import systems.dennis.shared.postgres.controller.EditItemController;
import systems.dennis.shared.postgres.controller.ListItemController;
import systems.dennis.shared.postgres.form.AppSettingsForm;
import systems.dennis.shared.postgres.model.AppSettingsModel;
import systems.dennis.shared.postgres.service.AppSettingsService;
import systems.dennis.shared.utils.ApplicationContext;

@RestController
@RequestMapping(value={"/api/v2/shared/app_settings"})
@WebFormsSupport(value=AppSettingsService.class)
@CrossOrigin
@Secured(roles={"ROLE_ADMIN"})
public class AppSettingsController
extends ApplicationContext
implements DeleteItemController<AppSettingsModel>,
ListItemController<AppSettingsModel, AppSettingsForm>,
EditItemController<AppSettingsModel, AppSettingsForm>,
AddItemController<AppSettingsModel, AppSettingsForm> {
    public AppSettingsController(WebContext context) {
        super(context);
    }

    @Override
    @GetMapping(value={"/list"})
    public ResponseEntity<Page<Map<String, Object>>> get(Long from, Integer limit, Integer page) {
        return ListItemController.super.get(from, limit, page);
    }

    @Override
    @PutMapping(value={"/edit/{id}"})
    public ResponseEntity<AppSettingsForm> edit(AppSettingsForm form) throws ItemForAddContainsIdException, ItemDoesNotContainsIdValueException, UnmodifiedItemSaveAttemptException, ItemNotFoundException {
        return EditItemController.super.edit(form);
    }

    @Override
    @PutMapping(value={"/add"})
    public ResponseEntity<AppSettingsForm> add(AppSettingsForm form) throws ItemForAddContainsIdException, ItemDoesNotContainsIdValueException, UnmodifiedItemSaveAttemptException, ItemNotFoundException {
        return EditItemController.super.edit(form);
    }

    @Override
    @DeleteMapping(value={"/delete/{id}"})
    public void delete(@PathVariable Long id) throws ItemNotUserException, ItemNotFoundException {
        DeleteItemController.super.delete(id);
    }
}

