package systems.dennis.shared.postgres.model;

import jakarta.persistence.*;
import lombok.Data;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import systems.dennis.shared.annotations.FormTransient;
import systems.dennis.shared.entity.AbstractEntity;

@MappedSuperclass
@Data
public class BaseEntity implements AbstractEntity<Long> {
    public static final int DELETE_STRATEGY_DB = 1;
    public static final int DELETE_STRATEGY_PROPERTY = 2;
    public static final String DELETE_PROPERTY = "hidden";
    @Id
    @GeneratedValue(generator = "entity-aware-generator",  strategy = GenerationType.SEQUENCE)
    @GenericGenerator(name = "entity-aware-generator",  parameters =  {
            @Parameter(name = "increment_size", value = "1"),
            @Parameter(name = "initial_value", value = "100")

    }, strategy = "systems.dennis.shared.postgres.model.ByEntityNameSequenceGenerator")
    private Long id;

    @FormTransient
    Boolean hidden;

    @Override
    public String asValue() {
        return String.valueOf(id);
    }

    @Override
    public boolean isIdSet() {
        return id != null && id > 0;
    }
}
