package systems.dennis.shared.postgres.controller;

import org.springframework.web.bind.annotation.*;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.controller.items.AbstractDeleteItemController;
import systems.dennis.shared.entity.AbstractEntity;
import systems.dennis.shared.exceptions.ItemForAddContainsIdException;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.exceptions.ItemNotUserException;

import java.util.List;

@RestController
@Secured
public interface DeleteItemController<T extends AbstractEntity<Long>> extends AbstractDeleteItemController<T,Long> {


    @PostMapping(value = "/edit",  consumes = {"application/json", "application/json;charset=UTF-8"}, produces = {"application/json", "application/json;charset=UTF-8"})
    @ResponseBody
    @WithRole
    @Override
    default void delete(Long form) throws ItemForAddContainsIdException {
        AbstractDeleteItemController.super.delete(form);
    }

    @Override
    @WithRole
    @RequestMapping(value="/delete/deleteItems", method= RequestMethod.POST)
    default void deleteItems(List<Long> ids) throws ItemNotUserException, ItemNotFoundException {
        AbstractDeleteItemController.super.deleteItems(ids);
    }
}
