/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.mongo.repository.query_processors;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import org.springframework.data.mongodb.core.query.Criteria;
import systems.dennis.shared.mongo.repository.MongoSpecification;
import systems.dennis.shared.mongo.repository.query_processors.BigDecimalProcessor;
import systems.dennis.shared.mongo.repository.query_processors.CollectionPredicateProcessor;
import systems.dennis.shared.mongo.repository.query_processors.DatePredicateProcessor;
import systems.dennis.shared.mongo.repository.query_processors.NumberPredicateProcessor;
import systems.dennis.shared.mongo.repository.query_processors.SimplePredicateProcessor;
import systems.dennis.shared.mongo.repository.query_processors.StringPredicateProcessor;
import systems.dennis.shared.repository.AbstractDataFilter;

public abstract class AbstractClassProcessor {
    private AbstractDataFilter filter;
    private Criteria root;
    private Class<?> type = String.class;
    private Object parameter = null;

    public AbstractClassProcessor(AbstractDataFilter AbstractDataFilter2, Criteria root) {
        this.filter = AbstractDataFilter2;
        this.root = root;
        if (AbstractDataFilter2.getFieldClass() == null && AbstractDataFilter2.getValue() != null) {
            this.type = AbstractDataFilter2.getValue().getClass();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isNotNullCase() {
        if ("notNull".equalsIgnoreCase(this.filter.getOperator())) return false;
        if ("null".equalsIgnoreCase(this.filter.getOperator())) return false;
        return true;
    }

    public void addToNullOrNotNullPredicate() {
        if (Objects.equals(this.getFilter().getOperator(), "null")) {
            this.getRoot().isNull();
        } else {
            this.getRoot().ne(null);
        }
    }

    public void processDefault() {
        Object value = this.getValue(this.filter.getValue());
        if (value == null) {
            throw new ArithmeticException("Item is wrong type");
        }
        if ("lt".equalsIgnoreCase(this.filter.getOperator())) {
            this.getRoot().lt(value);
        }
        if ("gt".equalsIgnoreCase(this.filter.getOperator())) {
            this.getRoot().gt(value);
        }
        if ("le".equalsIgnoreCase(this.filter.getOperator())) {
            this.getRoot().lte(value);
        }
        if ("ge".equalsIgnoreCase(this.filter.getOperator())) {
            this.getRoot().gte(value);
        }
        if ("notNull".equalsIgnoreCase(this.filter.getOperator())) {
            this.getRoot().ne(null);
        }
        if ("null".equalsIgnoreCase(this.filter.getOperator())) {
            this.getRoot().isNull();
        }
        if ("equals".equalsIgnoreCase(this.filter.getOperator()) && !String.class.isAssignableFrom(value.getClass())) {
            this.getRoot().is(value);
        }
        if ("notEquals".equalsIgnoreCase(this.filter.getOperator()) && !String.class.isAssignableFrom(value.getClass())) {
            this.getRoot().ne(value);
        }
        if ("in".equalsIgnoreCase(this.filter.getOperator())) {
            Collection cValue = (Collection)value;
            cValue.forEach(x -> this.filter.getValue());
            this.getRoot().in(new Object[]{value});
        }
    }

    public abstract Object getValue(Object var1);

    public static AbstractClassProcessor processor(AbstractDataFilter<?> filter) {
        Criteria root = ((MongoSpecification)filter).getRoot();
        if (filter.getFieldClass() != null && Collection.class.isAssignableFrom(filter.getFieldClass())) {
            return new CollectionPredicateProcessor(filter, root);
        }
        if (Date.class.equals((Object)filter.getFieldClass()) && !Date.class.isAssignableFrom(filter.getValue().getClass())) {
            return new DatePredicateProcessor(filter, root);
        }
        if (BigDecimal.class.equals((Object)filter.getFieldClass())) {
            return new BigDecimalProcessor(filter, root);
        }
        if (filter.getFieldClass() != null && (Number.class.isAssignableFrom(filter.getFieldClass()) || AbstractClassProcessor.isPrimitiveNumber(filter.getFieldClass()))) {
            return new NumberPredicateProcessor(filter, root);
        }
        if (filter.getFieldClass() != null && String.class.isAssignableFrom(filter.getFieldClass())) {
            return new StringPredicateProcessor(filter, root);
        }
        return new SimplePredicateProcessor(filter, root);
    }

    private static boolean isPrimitiveNumber(Class c) {
        return Integer.TYPE == c || Long.TYPE == c || Short.TYPE == c || Double.TYPE == c || Float.TYPE == c;
    }

    public AbstractDataFilter getFilter() {
        return this.filter;
    }

    public Criteria getRoot() {
        return this.root;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Object getParameter() {
        return this.parameter;
    }

    public void setFilter(AbstractDataFilter filter) {
        this.filter = filter;
    }

    public void setRoot(Criteria root) {
        this.root = root;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public void setParameter(Object parameter) {
        this.parameter = parameter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractClassProcessor)) {
            return false;
        }
        AbstractClassProcessor other = (AbstractClassProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AbstractDataFilter this$filter = this.getFilter();
        AbstractDataFilter other$filter = other.getFilter();
        if (this$filter == null ? other$filter != null : !this$filter.equals(other$filter)) {
            return false;
        }
        Criteria this$root = this.getRoot();
        Criteria other$root = other.getRoot();
        if (this$root == null ? other$root != null : !this$root.equals(other$root)) {
            return false;
        }
        Class<?> this$type = this.getType();
        Class<?> other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Object this$parameter = this.getParameter();
        Object other$parameter = other.getParameter();
        return !(this$parameter == null ? other$parameter != null : !this$parameter.equals(other$parameter));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractClassProcessor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AbstractDataFilter $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : $filter.hashCode());
        Criteria $root = this.getRoot();
        result = result * 59 + ($root == null ? 43 : $root.hashCode());
        Class<?> $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Object $parameter = this.getParameter();
        result = result * 59 + ($parameter == null ? 43 : $parameter.hashCode());
        return result;
    }

    public String toString() {
        return "AbstractClassProcessor(filter=" + String.valueOf(this.getFilter()) + ", root=" + String.valueOf(this.getRoot()) + ", type=" + String.valueOf(this.getType()) + ", parameter=" + String.valueOf(this.getParameter()) + ")";
    }
}

