package systems.dennis.shared.mongo.repository.query_processors;

import org.springframework.data.mongodb.core.query.Criteria;
import systems.dennis.shared.mongo.repository.MongoSpecification;
import systems.dennis.shared.repository.AbstractDataFilter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class CollectionPredicateProcessor extends AbstractClassProcessor {

    public CollectionPredicateProcessor(AbstractDataFilter<?> queryCase, Criteria root) {
        super(queryCase, root);
    }


    @Override
    public void processDefault() {

        var queryCase = getFilter();

        Criteria root = ((MongoSpecification<?>)queryCase).getRoot();
        if (AbstractDataFilter.CONTAINS_OPERATOR.equalsIgnoreCase(queryCase.getOperator())) {
            root.in(Collections.singleton(queryCase.getValue()));
        }
        if (AbstractDataFilter.NOT_CONTAINS_OPERATOR.equalsIgnoreCase(queryCase.getOperator())) {
            getRoot().nin(Collections.singleton(queryCase.getValue()));
        }
        if (AbstractDataFilter.NOT_EMPTY.equalsIgnoreCase(queryCase.getOperator())) {
            getRoot().ne(new ArrayList<>());
        }
        if (AbstractDataFilter.EMPTY.equalsIgnoreCase(queryCase.getOperator())) {
            getRoot().is(new ArrayList<>());
        }
        if (AbstractDataFilter.IN.equalsIgnoreCase(queryCase.getOperator())) {
            getRoot().in((Collection) queryCase.getValue());

        }
        if (AbstractDataFilter.NOT_IN.equalsIgnoreCase(queryCase.getOperator())) {
           getRoot().nin((Collection) queryCase.getValue());
        }
        if (AbstractDataFilter.NOT_EQUALS_OPERATOR.equalsIgnoreCase(queryCase.getOperator())) {
            getRoot().ne(queryCase.getValue());
        }

    }

    @Override
    public Object getValue(Object value) {
        return value;
    }
}
