package systems.dennis.shared.mongo.controller;

import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.SearchEntityApi;
import systems.dennis.shared.controller.SearcherInfo;
import systems.dennis.shared.mongo.model.LanguageModel;
import systems.dennis.shared.mongo.service.LanguageService;
import systems.dennis.shared.mongo.form.LanguageForm;
import systems.dennis.shared.utils.ApplicationContext;

@RestController
@RequestMapping("/api/v2/flaw/language")
@WebFormsSupport(LanguageService.class)
@CrossOrigin
@Secured (roles = "ROLE_ADMIN")
public class LanguageController
        extends ApplicationContext
        implements AddItemController<LanguageModel, LanguageForm>,
        EditItemController<LanguageModel, LanguageForm>,
        ListItemController<LanguageModel, LanguageForm>,
        DeleteItemController<LanguageModel> {

    static {
        SearchEntityApi.registerSearch("language", new SearcherInfo("name", LanguageService.class));
    }



    public LanguageController(WebContext context) {
        super(context);
    }

}
