package systems.dennis.shared.mongo.controller;

import lombok.SneakyThrows;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import systems.dennis.shared.controller.items.AbstractGetByIdController;
import systems.dennis.shared.controller.items.AbstractGetOrCreateByIdController;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.mongo.form.DefaultForm;
import systems.dennis.shared.mongo.service.StringIdEntity;

public interface GetByIdOrCreateController<DB_TYPE extends StringIdEntity, FORM extends DefaultForm> extends AbstractGetOrCreateByIdController<DB_TYPE, FORM,  String > {
    @SneakyThrows
    @GetMapping("/id/{id}")
    @ResponseBody
    default ResponseEntity<FORM> get(@PathVariable("id") String id, @RequestParam(required = false) String param) {
        DB_TYPE type = getService().findById(id).orElse(null);
        if (type == null) {
            var res = getService().save(fromForm(createNew(param)));
            return ResponseEntity.ok(toForm(res));
        }
        return ResponseEntity.ok(toForm(type));
    }
}
