/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.mongo.service;

import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.mongo.form.DeleteHistoryForm;
import systems.dennis.shared.mongo.model.DeleteHistoryModel;
import systems.dennis.shared.mongo.repository.DeleteHistoryRepo;
import systems.dennis.shared.mongo.repository.MongoSpecification;
import systems.dennis.shared.mongo.service.PaginationService;
import systems.dennis.shared.repository.AbstractRepository;

@Service
@DataRetrieverDescription(model=DeleteHistoryModel.class, form=DeleteHistoryForm.class, repo=DeleteHistoryRepo.class)
public class DeleteHistoryService
extends PaginationService<DeleteHistoryModel> {
    public DeleteHistoryService(WebContext holder) {
        super(holder);
    }

    public Optional<DeleteHistoryModel> findById(String id) {
        return this.getRepository().findById((Object)id);
    }

    public boolean existsByTypeAndDeletedId(String id, String type) {
        DeleteHistoryRepo repo = (DeleteHistoryRepo)this.getRepository();
        return repo.filteredCount(this.getFilterImpl().eq("deletedId", (Object)id).and(this.getFilterImpl().eq("classDeletedObject", (Object)type))) > 0L;
    }

    public Optional<DeleteHistoryModel> findByTypeAndDeletedId(String type, String id) {
        DeleteHistoryRepo repo = (DeleteHistoryRepo)this.getRepository();
        return repo.filteredFirst(this.getFilterImpl().eq("type", (Object)type).and(this.getFilterImpl().eq("deletedId", (Object)id)));
    }

    public Page<DeleteHistoryModel> findByType(String type) {
        DeleteHistoryRepo repo = (DeleteHistoryRepo)this.getRepository();
        return repo.filteredData((MongoSpecification)this.getFilterImpl().eq("type", (Object)type));
    }

    public <F extends AbstractRepository<DeleteHistoryModel, String>> F getRepository() {
        return (F)super.getRepository();
    }
}

