/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.mongo.repository;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.query.Criteria;
import systems.dennis.shared.exceptions.StandardException;
import systems.dennis.shared.model.IDPresenter;
import systems.dennis.shared.mongo.exception.IncorrectSpecification;
import systems.dennis.shared.mongo.repository.query_processors.AbstractClassProcessor;
import systems.dennis.shared.repository.AbstractDataFilter;

public class MongoSpecification<T extends IDPresenter<?>>
implements AbstractDataFilter<T> {
    private static final Logger log = LoggerFactory.getLogger(MongoSpecification.class);
    private static final String ID_FIELD = "id";
    public static final String OR_OPERATOR = "or";
    public static final String AND_OPERATOR = "and";
    private boolean empty;
    private boolean closed;
    private boolean insensitive;
    private boolean complex;
    private Class<?> type;
    private String operationType;
    private Object value;
    private String field;
    private String on;
    boolean calculated = false;
    private List<MongoSpecification<T>> or = new ArrayList<MongoSpecification<T>>();
    private List<MongoSpecification<T>> and = new ArrayList<MongoSpecification<T>>();
    private Criteria criteria;

    public MongoSpecification<T> operator(String field, Object value, String type) {
        if (this.isClosed()) {
            throw new StandardException((Serializable)((Object)"query_was_already_closed"), "only add/or functions are now available. Please check that 'operation' is performed after additional parameter' ");
        }
        if (field == null || type == null) {
            this.setEmpty(true);
            return this;
        }
        this.setEmpty(false);
        if (this.isCalculated()) {
            throw new StandardException((Serializable)((Object)"query_was_already_closed"), "due to limitations of Query you cannot use Query after you had already called method 'getCriteriaRoot()'");
        }
        this.field = field;
        this.value = value;
        this.operationType = type;
        this.criteria = Criteria.where((String)this.getField());
        AbstractClassProcessor qq = AbstractClassProcessor.processor(this);
        if (!qq.isNotNullCase()) {
            qq.addToNullOrNotNullPredicate();
        } else {
            qq.processDefault();
        }
        this.closed = true;
        return this;
    }

    public <E extends AbstractDataFilter<?>> E and(E filter) {
        this.checkCriteria();
        if (filter.isEmpty()) {
            return (E)this.copy((MongoSpecification)filter);
        }
        if (this.isCalculated()) {
            throw new StandardException((Serializable)((Object)"query_was_already_closed"), "due to limitations of Query you cannot use Query after you had already called method 'getCriteriaRoot()'");
        }
        this.and.add((MongoSpecification)filter);
        this.empty = false;
        return (E)this;
    }

    private void checkCriteria() {
        if (this.criteria == null) {
            this.criteria = Criteria.where((String)this.field);
        }
    }

    private MongoSpecification copy(MongoSpecification filter) {
        this.criteria = filter.criteria;
        this.type = filter.type;
        this.and = filter.and;
        this.or = filter.or;
        this.on = filter.on;
        this.complex = filter.complex;
        this.insensitive = filter.insensitive;
        this.field = this.field;
        this.setEmpty(false);
        return this;
    }

    public <E extends AbstractDataFilter<?>> E or(E filter) {
        if (this.isCalculated()) {
            throw new StandardException((Serializable)((Object)"query_was_already_closed"), "due to limitations of Query you cannot use Query after you had already called method 'getCriteriaRoot()'");
        }
        if (filter.isEmpty()) {
            return (E)this.copy((MongoSpecification)filter);
        }
        this.or.add((MongoSpecification)filter);
        this.empty = false;
        return (E)this;
    }

    public <E extends AbstractDataFilter<T>> E comparasionType(Class<?> type) {
        this.type = type;
        return (E)this;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public AbstractDataFilter<T> setInsensitive(boolean insensitive) {
        this.insensitive = insensitive;
        return this;
    }

    public AbstractDataFilter<T> setComplex(boolean complex) {
        this.complex = complex;
        return this;
    }

    public AbstractDataFilter<T> setJoinOn(String on) {
        this.on = on;
        return this;
    }

    public List<AggregationOperation> toAggregationOperations(Class<?> entityClass, MongoTemplate mongoTemplate) {
        ArrayList<AggregationOperation> operations = new ArrayList<AggregationOperation>();
        Map<String, List<Criteria>> matchCriterias = this.addOperations(operations, entityClass, mongoTemplate, AND_OPERATOR);
        List<Criteria> orCriterias = matchCriterias.get(OR_OPERATOR);
        List<Criteria> andCriterias = matchCriterias.get(AND_OPERATOR);
        Criteria finalCriteria = new Criteria();
        if (!orCriterias.isEmpty() && !andCriterias.isEmpty()) {
            finalCriteria = new Criteria().orOperator(new Criteria[]{new Criteria().andOperator(andCriterias.toArray(new Criteria[0])), new Criteria().orOperator(orCriterias.toArray(new Criteria[0]))});
        } else if (!orCriterias.isEmpty()) {
            finalCriteria.orOperator(orCriterias.toArray(new Criteria[0]));
        } else if (!andCriterias.isEmpty()) {
            finalCriteria.andOperator(andCriterias.toArray(new Criteria[0]));
        }
        if (!finalCriteria.getCriteriaObject().isEmpty()) {
            operations.add((AggregationOperation)Aggregation.match((Criteria)finalCriteria));
        }
        return operations;
    }

    private Map<String, List<Criteria>> addOperations(List<AggregationOperation> operations, Class<?> entityClass, MongoTemplate mongoTemplate, String operation) {
        HashMap<String, List<Criteria>> matchCriterias = new HashMap<String, List<Criteria>>();
        matchCriterias.put(OR_OPERATOR, new ArrayList());
        matchCriterias.put(AND_OPERATOR, new ArrayList());
        Criteria matchCriteria = this.on != null ? this.handleJoin(operations, entityClass, mongoTemplate) : this.handleNoJoin(operations, entityClass, mongoTemplate);
        if (matchCriteria != null) {
            ((List)matchCriterias.get(operation)).add(matchCriteria);
        }
        if (!this.or.isEmpty()) {
            for (MongoSpecification<T> spec : this.or) {
                Map<String, List<Criteria>> orMatchCriterias = spec.addOperations(operations, entityClass, mongoTemplate, OR_OPERATOR);
                this.mergeCriterias(matchCriterias, orMatchCriterias);
            }
        }
        if (!this.and.isEmpty()) {
            for (MongoSpecification<T> spec : this.and) {
                Map<String, List<Criteria>> andMatchCriterias = spec.addOperations(operations, entityClass, mongoTemplate, AND_OPERATOR);
                this.mergeCriterias(matchCriterias, andMatchCriterias);
            }
        }
        return matchCriterias;
    }

    private void mergeCriterias(Map<String, List<Criteria>> target, Map<String, List<Criteria>> source) {
        for (Map.Entry<String, List<Criteria>> entry : source.entrySet()) {
            target.get(entry.getKey()).addAll((Collection<Criteria>)entry.getValue());
        }
    }

    public Boolean shouldAggregate(Class<?> entityClass) {
        if (this.on != null) {
            try {
                Class<?> joinClass = entityClass.getDeclaredField(this.on).getType();
                Field joinField = joinClass.getDeclaredField(this.field);
                if (joinField.isAnnotationPresent(DBRef.class)) {
                    return true;
                }
            }
            catch (Exception e) {
                throw new IncorrectSpecification("Error processing join fields");
            }
        }
        for (MongoSpecification<T> spec : this.or) {
            if (!spec.shouldAggregate(entityClass).booleanValue()) continue;
            return true;
        }
        for (MongoSpecification<T> spec : this.and) {
            if (!spec.shouldAggregate(entityClass).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private Criteria handleJoin(List<AggregationOperation> operations, Class<?> entityClass, MongoTemplate mongoTemplate) {
        try {
            Class<?> joinClass = entityClass.getDeclaredField(this.on).getType();
            Field joinField = joinClass.getDeclaredField(this.field);
            String joinCollectionName = mongoTemplate.getCollectionName(joinClass);
            String rootCollectionName = mongoTemplate.getCollectionName(entityClass);
            String as = rootCollectionName + "_" + this.field;
            if (joinField.isAnnotationPresent(DBRef.class)) {
                String nestedCollectionName = mongoTemplate.getCollectionName(joinField.getType());
                return this.handleDbRefJoin(operations, joinCollectionName, rootCollectionName, nestedCollectionName);
            }
            return this.handleNonDbRefJoin(operations, joinCollectionName, rootCollectionName, as);
        }
        catch (Exception e) {
            throw new IncorrectSpecification("Error processing join fields");
        }
    }

    private Criteria handleDbRefJoin(List<AggregationOperation> operations, String joinCollectionName, String rootCollectionName, String nestedCollectionName) {
        String value = ((IDPresenter)this.criteria.getCriteriaObject().get((Object)this.getField())).getId().toString();
        String asJoin = joinCollectionName + "_" + rootCollectionName;
        String asNested = joinCollectionName + "_" + nestedCollectionName;
        Criteria matchCriteria = Criteria.where((String)(asNested + "._id")).is((Object)new ObjectId(value));
        operations.add((AggregationOperation)Aggregation.lookup((String)joinCollectionName, (String)(joinCollectionName + ".$id"), (String)"_id", (String)asJoin));
        operations.add((AggregationOperation)Aggregation.unwind((String)asJoin, (boolean)true));
        operations.add((AggregationOperation)Aggregation.lookup((String)nestedCollectionName, (String)(asJoin + "." + this.field + ".$id"), (String)"_id", (String)asNested));
        operations.add((AggregationOperation)Aggregation.unwind((String)asNested, (boolean)true));
        return matchCriteria;
    }

    private Criteria handleNonDbRefJoin(List<AggregationOperation> operations, String joinCollectionName, String rootCollectionName, String as) {
        Object value = this.criteria.getCriteriaObject().get((Object)this.getField());
        Criteria matchCriteria = Criteria.where((String)(as + "." + this.field)).is(value);
        operations.add((AggregationOperation)Aggregation.lookup((String)joinCollectionName, (String)(this.on + ".$id"), (String)"_id", (String)as));
        operations.add((AggregationOperation)Aggregation.unwind((String)as));
        return matchCriteria;
    }

    private Criteria handleNoJoin(List<AggregationOperation> operations, Class<?> entityClass, MongoTemplate mongoTemplate) {
        Field field;
        try {
            field = entityClass.getDeclaredField(this.field);
        }
        catch (Exception e) {
            field = null;
        }
        if (Objects.nonNull(field) && field.isAnnotationPresent(DBRef.class)) {
            return this.handleNoJoinDbRef(operations, entityClass, mongoTemplate);
        }
        return this.criteria;
    }

    private Criteria handleNoJoinDbRef(List<AggregationOperation> operations, Class<?> entityClass, MongoTemplate mongoTemplate) {
        String rootCollectionName = mongoTemplate.getCollectionName(entityClass);
        String as = rootCollectionName + "_" + this.field;
        String value = ((IDPresenter)this.criteria.getCriteriaObject().get((Object)this.getField())).getId().toString();
        Criteria matchCriteria = Criteria.where((String)(as + "._id")).is((Object)new ObjectId(value));
        operations.add((AggregationOperation)Aggregation.lookup((String)rootCollectionName, (String)(this.getField() + ".$id"), (String)"_id", (String)as));
        return matchCriteria;
    }

    public Serializable getIdValue(Object id) {
        return String.valueOf(id);
    }

    public String getOperator() {
        return this.operationType;
    }

    public Class<?> getFieldClass() {
        return this.type == null ? (this.value == null ? String.class : this.value.getClass()) : this.type;
    }

    public <E> E getQueryRoot() {
        if (this.calculated) {
            return (E)this.criteria;
        }
        for (MongoSpecification<T> mongoSpecification : this.or) {
            mongoSpecification.getQueryRoot();
        }
        if (!this.or.isEmpty()) {
            this.criteria.orOperator((Collection)this.or.stream().map(MongoSpecification::getCriteria).collect(Collectors.toList()));
        }
        for (MongoSpecification<T> tMongoSpecification : this.and) {
            tMongoSpecification.getQueryRoot();
        }
        if (!this.and.isEmpty()) {
            this.criteria.andOperator((Collection)this.and.stream().map(MongoSpecification::getCriteria).collect(Collectors.toList()));
        }
        this.calculated = true;
        return (E)this.criteria;
    }

    public Criteria getRoot() {
        return this.criteria;
    }

    public boolean getInsensitive() {
        return this.insensitive;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public boolean isComplex() {
        return this.complex;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getOperationType() {
        return this.operationType;
    }

    public Object getValue() {
        return this.value;
    }

    public String getField() {
        return this.field;
    }

    public String getOn() {
        return this.on;
    }

    public boolean isCalculated() {
        return this.calculated;
    }

    public List<MongoSpecification<T>> getOr() {
        return this.or;
    }

    public List<MongoSpecification<T>> getAnd() {
        return this.and;
    }

    public Criteria getCriteria() {
        return this.criteria;
    }

    public void setEmpty(boolean empty) {
        this.empty = empty;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public void setOperationType(String operationType) {
        this.operationType = operationType;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setOn(String on) {
        this.on = on;
    }

    public void setCalculated(boolean calculated) {
        this.calculated = calculated;
    }

    public void setOr(List<MongoSpecification<T>> or) {
        this.or = or;
    }

    public void setAnd(List<MongoSpecification<T>> and) {
        this.and = and;
    }

    public void setCriteria(Criteria criteria) {
        this.criteria = criteria;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MongoSpecification)) {
            return false;
        }
        MongoSpecification other = (MongoSpecification)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEmpty() != other.isEmpty()) {
            return false;
        }
        if (this.isClosed() != other.isClosed()) {
            return false;
        }
        if (this.getInsensitive() != other.getInsensitive()) {
            return false;
        }
        if (this.isComplex() != other.isComplex()) {
            return false;
        }
        if (this.isCalculated() != other.isCalculated()) {
            return false;
        }
        Class<?> this$type = this.getType();
        Class<?> other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$operationType = this.getOperationType();
        String other$operationType = other.getOperationType();
        if (this$operationType == null ? other$operationType != null : !this$operationType.equals(other$operationType)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$field = this.getField();
        String other$field = other.getField();
        if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
            return false;
        }
        String this$on = this.getOn();
        String other$on = other.getOn();
        if (this$on == null ? other$on != null : !this$on.equals(other$on)) {
            return false;
        }
        List<MongoSpecification<T>> this$or = this.getOr();
        List<MongoSpecification<T>> other$or = other.getOr();
        if (this$or == null ? other$or != null : !((Object)this$or).equals(other$or)) {
            return false;
        }
        List<MongoSpecification<T>> this$and = this.getAnd();
        List<MongoSpecification<T>> other$and = other.getAnd();
        if (this$and == null ? other$and != null : !((Object)this$and).equals(other$and)) {
            return false;
        }
        Criteria this$criteria = this.getCriteria();
        Criteria other$criteria = other.getCriteria();
        return !(this$criteria == null ? other$criteria != null : !this$criteria.equals(other$criteria));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MongoSpecification;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEmpty() ? 79 : 97);
        result = result * 59 + (this.isClosed() ? 79 : 97);
        result = result * 59 + (this.getInsensitive() ? 79 : 97);
        result = result * 59 + (this.isComplex() ? 79 : 97);
        result = result * 59 + (this.isCalculated() ? 79 : 97);
        Class<?> $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $operationType = this.getOperationType();
        result = result * 59 + ($operationType == null ? 43 : $operationType.hashCode());
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $field = this.getField();
        result = result * 59 + ($field == null ? 43 : $field.hashCode());
        String $on = this.getOn();
        result = result * 59 + ($on == null ? 43 : $on.hashCode());
        List<MongoSpecification<T>> $or = this.getOr();
        result = result * 59 + ($or == null ? 43 : ((Object)$or).hashCode());
        List<MongoSpecification<T>> $and = this.getAnd();
        result = result * 59 + ($and == null ? 43 : ((Object)$and).hashCode());
        Criteria $criteria = this.getCriteria();
        result = result * 59 + ($criteria == null ? 43 : $criteria.hashCode());
        return result;
    }

    public String toString() {
        return "MongoSpecification(empty=" + this.isEmpty() + ", closed=" + this.isClosed() + ", insensitive=" + this.getInsensitive() + ", complex=" + this.isComplex() + ", type=" + String.valueOf(this.getType()) + ", operationType=" + this.getOperationType() + ", value=" + String.valueOf(this.getValue()) + ", field=" + this.getField() + ", on=" + this.getOn() + ", calculated=" + this.isCalculated() + ", or=" + String.valueOf(this.getOr()) + ", and=" + String.valueOf(this.getAnd()) + ", criteria=" + String.valueOf(this.getCriteria()) + ")";
    }
}

