/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.mongo.controller;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.annotations.security.SelfOnlyRole;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.AbstractEntity;
import systems.dennis.shared.exceptions.HistoryObjectNotFoundException;
import systems.dennis.shared.mongo.controller.ListItemController;
import systems.dennis.shared.mongo.form.DeleteHistoryForm;
import systems.dennis.shared.mongo.model.DeleteHistoryModel;
import systems.dennis.shared.mongo.service.DeleteHistoryService;
import systems.dennis.shared.utils.ApplicationContext;

@RequestMapping(value={"/api/v2/deleted/history"})
@WebFormsSupport(value=DeleteHistoryService.class)
public class DeleteHistoryController
extends ApplicationContext
implements ListItemController<DeleteHistoryModel, DeleteHistoryForm> {
    public DeleteHistoryController(WebContext context) {
        super(context);
    }

    @GetMapping(value={"/find/{type}/{id}"})
    @SelfOnlyRole
    public DeleteHistoryForm findByDeletedIdAndType(@PathVariable String type, @PathVariable String id) {
        DeleteHistoryService service = (DeleteHistoryService)this.getService();
        return (DeleteHistoryForm)this.toForm((AbstractEntity)service.findByTypeAndDeletedId(type, id).orElseThrow(() -> new HistoryObjectNotFoundException((Serializable)((Object)id), type)));
    }

    @GetMapping(value={"/find/{type}"})
    @SelfOnlyRole
    public List<DeleteHistoryForm> findByType(@PathVariable String type) {
        DeleteHistoryService service = (DeleteHistoryService)this.getService();
        return service.findByType(type).stream().map(arg_0 -> ((DeleteHistoryController)this).toForm(arg_0)).collect(Collectors.toList());
    }
}

