package systems.dennis.shared.mongo.repository.query_processors;

import org.springframework.data.mongodb.core.query.Criteria;
import systems.dennis.shared.repository.AbstractDataFilter;

public class StringPredicateProcessor extends AbstractClassProcessor {

    public StringPredicateProcessor(AbstractDataFilter<?> queryCase, Criteria root) {
        super(queryCase, root);
    }


    @Override
    public void processDefault( ) {
        boolean selectInsensitive = true;
        var queryCase = getFilter();
        var value = getValue(queryCase.getValue());
        try {
            selectInsensitive = true; // (boolean)getFilter().getInsensitive();
        } catch (Exception ignored) {

        }
        String valueEx = String.valueOf(queryCase.getValue());

        if (AbstractDataFilter.CONTAINS_OPERATOR.equalsIgnoreCase(queryCase.getOperator())) {

            if (selectInsensitive) {
               getRoot().regex(".*" + value + ".*", "i");
            } else {
                getRoot().regex(".*" + value + ".*");
            }
        }
        if (AbstractDataFilter.NOT_CONTAINS_OPERATOR.equalsIgnoreCase(queryCase.getOperator())) {

            if (selectInsensitive) {
                getRoot().not().regex(".*" + value + ".*", "i");
            } else {
                getRoot().not().regex(".*" + value + ".*");
            }
        }

        if (AbstractDataFilter.EQUALS_OPERATOR.equalsIgnoreCase(queryCase.getOperator())) {

            if (!selectInsensitive) {
                getRoot().regex("" + value + "", "i");
            } else {
                getRoot().is(value);
            }
        }
        if (AbstractDataFilter.NOT_EQUALS_OPERATOR.equalsIgnoreCase(queryCase.getOperator())) {
            if (!selectInsensitive) {
                getRoot().not().regex("" + value + "", "i");
            } else {
                getRoot().ne(value);
            }
        }
        if (AbstractDataFilter.STARTS_WITH_OPERATOR.equalsIgnoreCase(queryCase.getOperator())) {


            if (!selectInsensitive) {
                getRoot().regex(".*" + value + "", "i");
            } else {
                getRoot().regex(".*" + value + "");
            }

        }
        if (AbstractDataFilter.NOT_STARTS_WITH_OPERATOR.equalsIgnoreCase(queryCase.getOperator())) {


            if (!selectInsensitive) {
                getRoot().not().regex(".*" + value + "", "i");
            } else {
                getRoot().not().regex(".*" + value + "");
            }


        }

        if (AbstractDataFilter.ENDS_WITH_OPERATOR.equalsIgnoreCase(queryCase.getOperator())) {


            if (!selectInsensitive) {
                getRoot().regex("" + value + "*.", "i");
            } else {
                getRoot().regex("" + value + "*.");
            }

        }
        if (AbstractDataFilter.NOT_ENDS_WITH_OPERATOR.equalsIgnoreCase(queryCase.getOperator())) {

            if (!selectInsensitive) {
                getRoot().not().regex("" + value + "*.", "i");
            } else {
                getRoot().not().regex("" + value + "*.");
            }


        }
    }

    @Override
    public Object getValue(Object value) {
        return value;
    }
}
