/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.mongo.specification;

import java.lang.reflect.ParameterizedType;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.repository.NoRepositoryBean;
import org.springframework.lang.Nullable;
import systems.dennis.shared.mongo.service.StringIdEntity;
import systems.dennis.shared.mongo.specification.MongoSpecificationExecutor;
import systems.dennis.shared.repository.AbstractDataFilter;
import systems.dennis.shared.repository.AbstractFilterRepo;
import systems.dennis.shared.repository.AbstractRepository;

@NoRepositoryBean
public class MongoSpecificationExecutorImpl<T extends StringIdEntity>
implements MongoSpecificationExecutor<T>,
AbstractRepository<T, String>,
AbstractFilterRepo<T, String> {
    private final MongoTemplate mongoTemplate;
    private final Class<T> entityClass;

    public MongoSpecificationExecutorImpl(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
        this.entityClass = this.getEntityClass();
    }

    public final Class<T> getEntityClass() {
        try {
            return (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Optional<T> filteredOne(@Nullable AbstractDataFilter<?> spec) {
        assert (spec != null);
        return Optional.ofNullable((StringIdEntity)((Object)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)((CriteriaDefinition)spec.getQueryRoot())), this.entityClass)));
    }

    @Override
    public Optional<T> filteredFirst(AbstractDataFilter<?> spec) {
        return this.filteredFirst(spec, null);
    }

    public Optional<T> filteredFirst(AbstractDataFilter<?> first, Sort sort) {
        Page<T> data = this.filteredData(first, Pageable.ofSize((int)1), sort);
        if (data.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((StringIdEntity)((Object)data.getContent().get(0)));
    }

    @Override
    public Page<T> filteredData(@Nullable AbstractDataFilter<?> spec) {
        return this.filteredData(spec, (Sort)null);
    }

    @Override
    public Page<T> filteredData(@Nullable AbstractDataFilter<?> spec, Pageable pageable) {
        return this.filteredData(spec, pageable, null);
    }

    @Override
    public Page<T> filteredData(AbstractDataFilter<?> spec, Sort sort) {
        if (spec == null) {
            return this.filteredData(spec, Pageable.unpaged(), sort);
        }
        return this.filteredData(spec, Pageable.unpaged(), sort);
    }

    public Page<T> filteredData(AbstractDataFilter<?> spec, Pageable pageable, Sort sort) {
        if (spec == null) {
            return this.findAll(pageable);
        }
        Query query = Query.query((CriteriaDefinition)((CriteriaDefinition)spec.getQueryRoot()));
        if (sort != null) {
            query = query.with(sort);
        }
        if (pageable != null) {
            query = query.with(pageable);
        }
        List items = this.mongoTemplate.find(query, this.entityClass);
        long count = this.filteredCount(spec);
        return new PageImpl(items, pageable == null ? Pageable.unpaged() : pageable, count);
    }

    @Override
    public long filteredCount(@Nullable AbstractDataFilter<?> spec) {
        if (spec == null || spec.isEmpty()) {
            return this.count();
        }
        return this.mongoTemplate.count(Query.query((CriteriaDefinition)((CriteriaDefinition)spec.getQueryRoot())), this.entityClass);
    }

    public List<T> filteredData(Sort sort) {
        return this.mongoTemplate.find(new Query().with(sort), this.entityClass);
    }

    public Page<T> findAll(Pageable pageable) {
        List items = this.mongoTemplate.find(new Query().with(pageable), this.entityClass);
        long count = this.count();
        return new PageImpl(items, pageable, count);
    }

    public <S extends T> S save(S entity) {
        return (S)((Object)((StringIdEntity)((Object)this.mongoTemplate.save(entity))));
    }

    @Deprecated
    public <S extends T> Iterable<S> saveAll(Iterable<S> entities) {
        throw new IllegalAccessException("Use method save(T item)  instead of this");
    }

    public Optional<T> findById(String s) {
        return Optional.ofNullable((StringIdEntity)((Object)this.mongoTemplate.findById((Object)s, this.entityClass)));
    }

    public boolean existsById(String s) {
        return this.mongoTemplate.exists(this.idIs(s), this.entityClass);
    }

    public List<T> findAll() {
        return this.mongoTemplate.findAll(this.entityClass);
    }

    public Iterable<T> findAllById(Iterable<String> ids) {
        return this.mongoTemplate.find(new Query((CriteriaDefinition)Criteria.where((String)"id").in(new Object[]{ids})), this.entityClass);
    }

    public long count() {
        return this.mongoTemplate.count(new Query(), this.entityClass);
    }

    public void deleteById(String s) {
        this.mongoTemplate.remove(this.idIs(s), this.entityClass);
    }

    public void delete(T entity) {
        this.mongoTemplate.remove(entity);
    }

    public void deleteAllById(Iterable<? extends String> strings) {
        strings.forEach(this::deleteById);
    }

    public void deleteAll(Iterable<? extends T> entities) {
        entities.forEach(this::delete);
    }

    public void deleteAll() {
        this.mongoTemplate.findAllAndRemove(new Query(), this.entityClass);
    }

    private Query idIs(String s) {
        return new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)s));
    }
}

