/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.mongo.repository.query_processors;

import java.math.BigInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.query.Criteria;
import systems.dennis.shared.mongo.repository.query_processors.AbstractClassProcessor;
import systems.dennis.shared.repository.AbstractDataFilter;

public class NumberPredicateProcessor
extends AbstractClassProcessor {
    private static final Logger log = LoggerFactory.getLogger(NumberPredicateProcessor.class);

    public NumberPredicateProcessor(AbstractDataFilter queryCase, Criteria root) {
        super(queryCase, root);
    }

    @Override
    public Object getValue(Object value) {
        try {
            if (value instanceof Number) {
                return this.getNumberFromString(String.valueOf(value), this.getFilter().getFieldClass());
            }
            return null;
        }
        catch (Exception e) {
            log.warn("Search is not able to parse date: " + String.valueOf(value), (Throwable)e);
            return null;
        }
    }

    private Number getNumberFromString(String value, Class<?> fieldClass) {
        if (Integer.class.equals(fieldClass)) {
            return Integer.valueOf(value);
        }
        if (Double.class.equals(fieldClass)) {
            return Double.valueOf(value);
        }
        if (Long.class.equals(fieldClass)) {
            return Long.valueOf(value);
        }
        if (Short.class.equals(fieldClass)) {
            return Short.valueOf(value);
        }
        if (BigInteger.class.equals(fieldClass)) {
            return BigInteger.valueOf(Long.parseLong(value));
        }
        throw new IllegalArgumentException(" cannot transform String to number! ");
    }
}

