package systems.dennis.shared.mongo.service;

import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.MappedSuperclass;
import lombok.Data;

import systems.dennis.shared.model.IDPresenter;

@MappedSuperclass
@Data
public abstract class StringIdEntity extends IDPresenter<String> {
    @Id
    @GeneratedValue
    private String id;

    @Override
    public boolean isIdSet() {
        return id != null && !id.isBlank();
    }
}
