package systems.dennis.shared.mongo.service;

import org.springframework.data.domain.Page;
import systems.dennis.shared.repository.AbstractDataFilter;
import systems.dennis.shared.service.AbstractParentalService;
import systems.dennis.shared.service.AbstractService;

public interface ParentalService <DB_TYPE extends StringIdEntity> extends AbstractService<DB_TYPE, String>,
        AbstractParentalService<DB_TYPE, String> {

    @Override
    default long countByParent(String id) {
        AbstractDataFilter<DB_TYPE> specification = getFilterImpl().eq(getParentField(), id);
        return getRepository().filteredCount(specification.and(getAdditionalSpecification()));
    }

    @Override
    default Page<DB_TYPE> findByParent(String parentId, int limit, int page) {
        AbstractDataFilter<DB_TYPE> specification = getFilterImpl().eq(getParentField(), parentId);
        return find(specification.and(getAdditionalSpecification()),  limit, page);
    }
}
