package systems.dennis.shared.mongo.controller;

import org.springframework.web.bind.annotation.*;
import systems.dennis.shared.annotations.security.Id;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.controller.items.AbstractDeleteItemController;
import systems.dennis.shared.exceptions.ItemForAddContainsIdException;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.exceptions.ItemNotUserException;
import systems.dennis.shared.mongo.service.StringIdEntity;
import systems.dennis.shared.utils.security.DefaultIdChecker;

import java.util.List;

@Secured
public interface DeleteItemController<T extends StringIdEntity> extends AbstractDeleteItemController<T,String> {


    @DeleteMapping(value = "/delete/{id}",  consumes = {"application/json", "application/json;charset=UTF-8"}, produces = {"application/json", "application/json;charset=UTF-8"})
    @ResponseBody
    @WithRole
    @Override
    default void delete(@Id(checker = DefaultIdChecker.class) @PathVariable String id) throws ItemForAddContainsIdException {
        AbstractDeleteItemController.super.delete(id);
    }

    @Override
    @WithRole
    @RequestMapping(value="/delete/deleteItems", method= RequestMethod.DELETE)
    default void deleteItems(@RequestParam List<String> ids) throws ItemNotUserException, ItemNotFoundException {
        AbstractDeleteItemController.super.deleteItems(ids);
    }
}
