/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.mongo.service;

import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.mongo.form.EditHistoryForm;
import systems.dennis.shared.mongo.model.EditHistoryModel;
import systems.dennis.shared.mongo.repository.EditHistoryRepo;
import systems.dennis.shared.mongo.repository.MongoSpecification;
import systems.dennis.shared.mongo.service.PaginationService;

@Service
@DataRetrieverDescription(model=EditHistoryModel.class, form=EditHistoryForm.class, repo=EditHistoryRepo.class)
public class EditHistoryService
extends PaginationService<EditHistoryModel> {
    public EditHistoryService(WebContext holder) {
        super(holder);
    }

    public Optional<EditHistoryModel> findById(String id) {
        return this.getRepository().filteredOne(this.getFilterImpl().id((Object)id));
    }

    public Optional<EditHistoryModel> findByEditedTypeAndId(String type, String id) {
        EditHistoryRepo repo = this.getRepository();
        return repo.filteredFirst(this.getFilterImpl().eq("editedTpe", (Object)type).and(this.getFilterImpl().eq("idEditedObject", (Object)id)));
    }

    public Page<EditHistoryModel> findByEditedType(String type) {
        EditHistoryRepo repo = this.getRepository();
        return repo.filteredData((MongoSpecification)this.getFilterImpl().eq("classEditedObject", (Object)type));
    }

    public EditHistoryRepo getRepository() {
        return (EditHistoryRepo)super.getRepository();
    }
}

