/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.mongo.bean;

import java.io.Serializable;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.beans.AbstractEditDeleteHistoryBean;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.exceptions.DeleteNotPossibleException;
import systems.dennis.shared.exceptions.ItemWasDeletedException;
import systems.dennis.shared.mongo.model.DeleteHistoryModel;
import systems.dennis.shared.mongo.model.EditHistoryModel;
import systems.dennis.shared.mongo.service.DeleteHistoryService;
import systems.dennis.shared.mongo.service.EditHistoryService;
import systems.dennis.shared.mongo.service.StringIdEntity;
import systems.dennis.shared.utils.Mapper;

@Service
@Primary
public class MongoSaveEditDeleteHistory
extends AbstractEditDeleteHistoryBean<StringIdEntity, String> {
    private static final Logger log = LoggerFactory.getLogger(MongoSaveEditDeleteHistory.class);

    public MongoSaveEditDeleteHistory(WebContext context) {
        super(context);
    }

    public void edit(StringIdEntity from, StringIdEntity to) {
        EditHistoryModel editableObject = EditHistoryModel.from(from, to);
        ((EditHistoryService)((Object)this.getContext().getBean(EditHistoryService.class))).save(editableObject);
    }

    public void delete(String id, StringIdEntity model) {
        if (id == null || model == null) {
            throw new DeleteNotPossibleException("id_or_model_are_null", (Serializable)((Object)id));
        }
        try {
            DeleteHistoryModel deleteHistoryModel = new DeleteHistoryModel();
            deleteHistoryModel.setDeletedDate(new Date());
            deleteHistoryModel.setContent(Mapper.mapper.writeValueAsString((Object)model));
            deleteHistoryModel.setClassDeletedObject(((Object)((Object)model)).getClass().getSimpleName());
            boolean deletedObjectExists = ((DeleteHistoryService)((Object)this.getBean(DeleteHistoryService.class))).existsByTypeAndDeletedId(id, ((Object)((Object)this)).getClass().getAnnotation(DataRetrieverDescription.class).model().getSimpleName());
            if (deletedObjectExists) {
                throw new ItemWasDeletedException((Serializable)((Object)id), ((Object)((Object)model)).getClass());
            }
        }
        catch (Exception e) {
            log.debug("cannot save object history: ", (Throwable)e);
        }
    }

    public void throwIfDeleted(String id, Class model) {
        if (model == null || id == null) {
            return;
        }
        boolean deletedObjectExists = ((DeleteHistoryService)((Object)this.getBean(DeleteHistoryService.class))).existsByTypeAndDeletedId(id, model.getSimpleName());
        if (deletedObjectExists) {
            throw new ItemWasDeletedException((Serializable)((Object)id), model.getClass().getSuperclass());
        }
    }
}

