package systems.dennis.shared.mongo.service;

import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.mongo.model.DeleteHistoryModel;
import systems.dennis.shared.mongo.repository.DeleteHistoryRepo;
import systems.dennis.shared.mongo.form.DeleteHistoryForm;
import systems.dennis.shared.mongo.repository.MongoSpecification;
import systems.dennis.shared.repository.AbstractRepository;


import java.util.List;
import java.util.Optional;

@Service
@DataRetrieverDescription(model = DeleteHistoryModel.class, form = DeleteHistoryForm.class, repo = DeleteHistoryRepo.class)
public class DeleteHistoryService extends PaginationService<DeleteHistoryModel> {
    public DeleteHistoryService(WebContext holder) {
        super(holder);
    }


    public Optional<DeleteHistoryModel> findById(String id) {
        return getRepository().findById(id);
    }

    public boolean existsByTypeAndDeletedId(String id, String type) {
        DeleteHistoryRepo repo = getRepository();



        return repo.filteredCount(getFilterImpl().eq("deletedId", id).and(getFilterImpl().eq("classDeletedObject", type))) > 0;
    }

    public Optional<DeleteHistoryModel> findByTypeAndDeletedId(String type, String id) {
        DeleteHistoryRepo repo = getRepository();
        return repo.filteredFirst(getFilterImpl().eq("type", type).and(getFilterImpl().eq("deletedId", id)));



    }

    public Page<DeleteHistoryModel> findByType(String type) {
        DeleteHistoryRepo repo = getRepository();
        return repo.filteredData((MongoSpecification<DeleteHistoryModel>) getFilterImpl().eq("type", type));

    }

    @Override
    public <F extends AbstractRepository<DeleteHistoryModel, String>> F getRepository() {
        return super.getRepository();
    }
}
