/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.mongo.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import java.util.Date;
import systems.dennis.shared.mongo.service.StringIdEntity;

@Entity(name="delete_history_object")
public class DeleteHistoryModel
extends StringIdEntity {
    @Column(name="deleted_id")
    private String idDeletedObject;
    private Date deletedDate = new Date();
    @Column(name="object_type")
    private String classDeletedObject;
    @Column(columnDefinition="text")
    private String content;

    public static DeleteHistoryModel from(StringIdEntity deleted) {
        ObjectMapper objectMapper = new ObjectMapper();
        String content = objectMapper.writeValueAsString((Object)deleted);
        DeleteHistoryModel model = new DeleteHistoryModel();
        model.setIdDeletedObject(deleted.getId());
        model.setClassDeletedObject(((Object)((Object)deleted)).getClass().getSimpleName());
        model.setContent(content);
        return model;
    }

    public String asValue() {
        return this.classDeletedObject + this.getId();
    }

    public String getIdDeletedObject() {
        return this.idDeletedObject;
    }

    public Date getDeletedDate() {
        return this.deletedDate;
    }

    public String getClassDeletedObject() {
        return this.classDeletedObject;
    }

    public String getContent() {
        return this.content;
    }

    public void setIdDeletedObject(String idDeletedObject) {
        this.idDeletedObject = idDeletedObject;
    }

    public void setDeletedDate(Date deletedDate) {
        this.deletedDate = deletedDate;
    }

    public void setClassDeletedObject(String classDeletedObject) {
        this.classDeletedObject = classDeletedObject;
    }

    public void setContent(String content) {
        this.content = content;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteHistoryModel)) {
            return false;
        }
        DeleteHistoryModel other = (DeleteHistoryModel)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$idDeletedObject = this.getIdDeletedObject();
        String other$idDeletedObject = other.getIdDeletedObject();
        if (this$idDeletedObject == null ? other$idDeletedObject != null : !this$idDeletedObject.equals(other$idDeletedObject)) {
            return false;
        }
        Date this$deletedDate = this.getDeletedDate();
        Date other$deletedDate = other.getDeletedDate();
        if (this$deletedDate == null ? other$deletedDate != null : !((Object)this$deletedDate).equals(other$deletedDate)) {
            return false;
        }
        String this$classDeletedObject = this.getClassDeletedObject();
        String other$classDeletedObject = other.getClassDeletedObject();
        if (this$classDeletedObject == null ? other$classDeletedObject != null : !this$classDeletedObject.equals(other$classDeletedObject)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        return !(this$content == null ? other$content != null : !this$content.equals(other$content));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DeleteHistoryModel;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $idDeletedObject = this.getIdDeletedObject();
        result = result * 59 + ($idDeletedObject == null ? 43 : $idDeletedObject.hashCode());
        Date $deletedDate = this.getDeletedDate();
        result = result * 59 + ($deletedDate == null ? 43 : ((Object)$deletedDate).hashCode());
        String $classDeletedObject = this.getClassDeletedObject();
        result = result * 59 + ($classDeletedObject == null ? 43 : $classDeletedObject.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "DeleteHistoryModel(idDeletedObject=" + this.getIdDeletedObject() + ", deletedDate=" + String.valueOf(this.getDeletedDate()) + ", classDeletedObject=" + this.getClassDeletedObject() + ", content=" + this.getContent() + ")";
    }

    public DeleteHistoryModel(String idDeletedObject, Date deletedDate, String classDeletedObject, String content) {
        this.idDeletedObject = idDeletedObject;
        this.deletedDate = deletedDate;
        this.classDeletedObject = classDeletedObject;
        this.content = content;
    }

    public DeleteHistoryModel() {
    }
}

